;
; Material for volcanic cooling exercise for Reepham High School tree ring activity
;
; Get regional data (incl. ALL) plus instrumental
;
restore,filename='regtemp_calibrated.allversion.idlsave'
; Gets: nyr, nreg, calregts,regname,timey,tempregts,tempnyr,temptimey
nyr1=nyr
;
; Get combined HugHF AgeLF for the ALL region (overwrites nyr)
;
restore,filename='combtempALL_calibrated.idlsave'
; Gets: nyr, yrmxd, prednh
;
; Adjust ALL trees to have mean of 100 and sd of 15
;
mknormal,prednh
prednh=(prednh*15)+100.
;
ireg=9
print,'region ',regname[ireg]
;
per=[1881,1960]
kmxd=where((yrmxd ge per[0]) and (yrmxd le per[1]),nkmxd)
kobs=where((temptimey ge per[0]) and (temptimey le per[1]),nkobs)
if nkmxd ne nkobs then message,'Ooops!'
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=1,layout='large',/landscape
if !d.name eq 'X' then begin
  win
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=18
endelse
makecolors,['magenta','red','mred','brown','orange','mdyellow','green',$
 'vlblue','mlblue','deepblue','lpurple','palepurple','black','mgrey'],indgen(14)+20
;
acoeff=linfit(prednh[kmxd],tempregts[kobs,ireg])
print,correlate(prednh[kmxd],tempregts[kobs,ireg])
;
xr=[20,140]
yr=acoeff[0]+acoeff[1]*xr
print,xr
print,yr
plot,prednh[kmxd],tempregts[kobs,ireg],psym=1,$
 xtitle='Tree-ring measurement',xstyle=1,xrange=xr,$
 ytitle='Summer temperature deviation  (!Uo!NC)',ystyle=1,yrange=[-3,1]
;
oplot,xr,yr,noclip=0,thick=5
;
end
