;
; Plots changes in correlations between regional MXD and regional monthly &
; seasonal precip. and temperature.  Partial correlations for precip., full
; for temp.
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
endcase
titadd=strupcase(fnadd)
;
; Restore all correlations
;
restore,filename='comp'+fnadd+'_moncorr_early.idlsave'
;  allr,ncorr,nvar,ncomp,compname,varname,corrname,allp,lowr,lowp,thalf
allr1=lowr
allp1=lowp
restore,filename='comp'+fnadd+'_moncorr_late.idlsave'
;  allr,ncorr,nvar,ncomp,compname,varname,corrname,allp,lowr,lowp,thalf
allr2=lowr
allp2=lowp
restore,filename='comp'+fnadd+'_moncorr.idlsave'
;  allr,ncorr,nvar,ncomp,compname,varname,corrname,allp,lowr,lowp,thalf
;
; Combine temp r with prec partial r
;
regr=allr
regr(*,*,0)=lowr(*,*,1)
regr(*,*,1)=lowp(*,*,0)
varname=reverse(varname)
conname=['',' constant Temp']
yname=['Correlation','Partial correlation']
earr=allr1
earr(*,*,0)=allr1(*,*,1)
earr(*,*,1)=allp1(*,*,0)
latr=allr2
latr(*,*,0)=allr2(*,*,1)
latr(*,*,1)=allp2(*,*,0)
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2,layout='caption'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='vlgrey'
def_1color,21,color='mgrey'
;
for i = 0 , ncomp-1 do begin
  for ivar = 0 , nvar-1 do begin
    pause
    x=findgen(28)
    yy=reform(earr(i,*,ivar))
    y=fltarr(28)*!values.f_nan
    yloc=[indgen(16)+1,indgen(5)*2+18]
    y(yloc)=yy(*)
    plot,x,y,/nodata,$
      /ystyle,yrange=[-1.,1.],ytitle=yname(ivar),$
      xstyle=5,title=compname(i)+'  r('+titadd+','+varname(ivar)+')'+conname(ivar)
    for j = -10,10,2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
    oplot,!x.crange,[0.,0.]
    oplot,[7.5,7.5],!y.crange,thick=4
    cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
    if !d.name eq 'PS' then device,font_size=8
    for j = 0 , ncorr-1 do begin
      x1=x(yloc(j))
      y1ear=earr(i,j,ivar)
      y1lat=latr(i,j,ivar)
;      plots,x1,y1ear,psym=def_sym(6)
      plots,x1,y1lat,psym=def_sym(10)
      x1=x(yloc(j))+0.28
      y1=!y.crange(0)-0.05
      if !p.multi(0) le 1 then xyouts,x1,y1,corrname(j),align=1,orient=90.
    endfor
    xyouts,7.,-0.85,align=1.,'Previous!Cyear'
    xyouts,8.,-0.85,align=0.,'Same!Cyear'
    if !d.name eq 'PS' then device,font_size=14
  endfor
endfor
;
end
