;
; Plots long chronologies from Taimyr and Tornetraske and Yamal
;
loadct,39
multi_plot,nrow=2,/landscape
if !d.name eq 'X' then begin
  window,xsize=900
  !p.font=1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
def_1color,10,color='mdgrey'
def_1color,11,color='vlgrey'
;
mtit=['Tornetrask','Yamal','Taimyr']
fn=['tornad.rcs','yamal.rcs','taimyr2.rcs']
nts=n_elements(fn)
nts=1
allnyr=2000
allyear=findgen(allnyr)
allts=fltarr(nts,allnyr)
;
; Repeat for each series
;
for i = 0 , nts-1 do begin
  ;
  ; First read in the appropriate data
  ;
  yrsten=intarr(2)
  openr,1,fn(i)
  readf,1,yrsten,format='(6X,2I4)'
  y1=yrsten(0) & adj1=(y1 mod 10) & y1=y1-adj1
  y2=yrsten(1) & adj2=9-(y2 mod 10) & y2=y2+adj2
  print,fn(i),yrsten,y1,y2
  nyr=y2-y1+1
  rawdat=fltarr(2,nyr)
  onedat=fltarr(2,10)
  for j = 0 , nyr-1 , 10 do begin
    readf,1,onedat,format='(10X,10(I4,I3))'
    rawdat(*,j:j+9)=onedat(*,*)
  endfor
  close,1
  ;
  ; Now sort out the missing data
  ;
  timey=findgen(nyr)+y1
  ts=reform(rawdat(0,*))
  ml=where(ts eq 9990,nmiss)
  if nmiss gt 0 then ts(ml)=!values.f_nan
  ;
  ; Now normalise relative to their entire length, and then filter
  ;
  mknormal,ts
  filter_cru,50.,/nan,tsin=ts,tslow=tslow
  ;
  ; Now accumulate the average series
  ;
  if total(abs(allyear-timey)) ne 0 then message,'Ooops!'
  allts(i,*)=ts(*)
  ;
  ; Now plot them
  ;
  cpl_barts,timey,ts,$
    /xstyle,/ystyle,ytitle='Normalised anomaly',yrange=[-3.5,3],$
    title=mtit(i)
  oplot,!x.crange,[0.,0.]
  ;
  cpl_barts,timey,tslow,bar_color=[10,11],outline=0,$
    /xstyle,/ystyle,ytitle='Smoothed!Cnormalised anomaly',yrange=[-3.5,3],$
    title=mtit(i)
  oplot,!x.crange,[0.,0.]
  oplot,timey,tslow,thick=2
  ;
endfor
;
end
