;
; Computes lists of tree numbers in each region
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
x=statlon
y=statlat
;
; Define arrays
;
maxtrees=nchron
regname=['NEUR','SEUR','NSIB','ESIB','CAS','TIBP','WNA','NWNA','ECCA']
nreg=n_elements(regname)
ntree=intarr(nreg)
treelist=fltarr(maxtrees,nreg)*!values.f_nan
;
; 1) Northern Europe
;
i=0
kl=where( (x gt -15.) and (x le 61.) and (y gt 53.) and $
          ((x le 30.) or (y gt 60.)) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 2) Southern Europe
;
i=1
kl=where( (x gt -15.) and (x le 30.) and (y le 53.) and (y gt 35.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 3) Northern Siberia
;
i=2
kl=where( (x gt 61.) and (x le 128.) and (y gt 60.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 4) Eastern Siberia
;
i=3
kl=where( ((x gt 128.) or (x le -170.)) and (y gt 60.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 5) Central Asia
;
i=4
kl=where( (x gt 30.) and (x le 115.) and (y le 60.) and (y gt 40.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 6) Tibetan Plateau
;
i=5
kl=where( (x gt 60.) and (x le 115.) and (y le 40.) and (y gt 23.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 7) Western North America
;
i=6
kl=where( (x gt -135.) and (x le -100.) and (y le 50.) and (y gt 30.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 8) North western North America
;
i=7
kl=where( (x gt -170.) and (x le -105.) and (y gt 50.) and $
  ((x le -120.) or (y le 55.)) and ((x le -125.) or (y le 60.)) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
; 9) Eastern & central Canada
;
i=8
kl=where( (x gt -125.) and (x le -45.) and (y gt 40.) and $
          ((x gt -120.) or (y gt 60.)) and $
          ((x gt -105.) or (y gt 55.)) and $
          ((x gt -100.) or (y gt 50.)) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=kl(*)
;
save,filename='reg_mxdlists.idlsave',ntree,treelist,nreg,regname
;
end
