function mkallmeans,x,n
;
; For a given time series x (of size nx), this function
; computes time series of non-overlapping means of n values
; but for all possible starting points.
;
nx=n_elements(x)
;
ny=ceil(nx/n)
y=fltarr(ny,n)*!values.f_nan
;
for i = 0 , n-1 do begin
  ;
  nyuse=ny
  iend=i+nyuse*n-1
  if iend gt nx-1 then nyuse=nyuse-1
  iend=i+nyuse*n-1
  z=x[i:iend]
  z=reform(z,n,nyuse)
  z=total(z,1)/float(n)
  y[0:nyuse-1,i]=z[*]
  ;
endfor
;
return,y
;
end
