;
; Create an Apr-Sep mean timeseries of gridded land air temperature from
; monthly observations.  Only the northern hemisphere is kept.
; Due to so much missing
; data I allow just 3 months of obs to be enough to get a AMJJAS mean, and then
; if any point is missing at a particular time but 3 or more surrounding
; points have values then it is infilled with the mean of those points.
; Also plots the long-term s.d.
;
print,'Reading in IPCC global IST gridded data'
ncid=ncdf_open('/cru/u2/f055/data/obs/grid/surface/lat_jones_18511998.mon.nc')
fdmon=crunc_rddata(ncid,tst=[1922,0],tend=[1995,11],grid=g,info=i)
ncdf_close,ncid
;
; Compute Apr-Sep means from the data (requiring 3 or more months of data)
;
nmon=12
nyr=g.nt/nmon
fdmon=reform(fdmon,g.nx*g.ny,nmon,nyr)
fdseas=mkseason(fdmon,3,8,datathresh=3)
fdseas=reform(fdseas,g.nx,g.ny,nyr)
timey=findgen(nyr)+g.year(0)
;
xlon=g.x
ylat=g.y
nx=g.nx
ny=g.ny
;
; Now do some infilling if possible from surrounding values
;
print,'Smoothing',nyr
for i = 0 , nyr-1 do begin
  print,i
  onefd=reform(fdseas(*,*,i))
  fdinf=tim_infill(onefd,3.,/cyclic,thresh=0.42,ylat=ylat)
  fdseas(*,*,i)=fdinf(*,*)
endfor
;
; Just keep the northern hemisphere stuff
;
ykeep=where(ylat ge 0.,ny)
ylat=ylat(ykeep)
fdseas=fdseas(*,ykeep,*)
;
; Now compute long-term mean and s.d.
;
fdd=double(fdseas)
fdtot=total(fdd,3,/nan)
fdnum=float(total(finite(fdd),3))
fdltm=fdtot/fdnum
ml=where(fdnum lt 30.,nmiss)
if nmiss gt 0 then fdltm(ml)=!values.f_nan
;
fdsqu=total(fdd^2,3,/nan)
fdsqu=fdsqu/fdnum
fdsd=sqrt(fdsqu-fdltm^2)
;
; Now compute a year-by-year timeseries of the fraction of missing data
;
nall=total(finite(fdltm))
nmiss=float(total(finite(fdseas),1))
nmiss=1.-(total(nmiss,1)/nall)
missfrac=nmiss
;
save,filename='obs_lat_as.idlsave',timey,fdseas,xlon,ylat,nyr,nx,ny,$
  fdltm,fdsd,missfrac
;
loadct,39
multi_plot,nrow=2
if !d.name eq 'X' then window,ysize=850
;
map=def_map(/npolar)  &  map.limit(0)=15.
coast=def_coast(/get_device)
labels=def_labels(/off)
;
levels=findgen(17)*0.1
inter_boxfd,fdsd,xlon,ylat,$
  /scale,$
  title='Long-term-standard deviation Apr-Sep temperature',$
  map=map,coast=coast,labels=labels,$
  levels=levels
;
plot,timey,missfrac,psym=10,/xstyle,xtitle='Year',$
  ytitle='Fraction of data missing per summer',yrange=[0.,0.5],/ystyle
;
end
