;
; Calibrates the gridded and infilled MXD data against instrumental
; summer temperatures (land&sea).  On a grid-box basis first, using the
; period 1911-1990 for calibration and the period 1856-1910 for verification,
; where data is available.
;
; Due to the decline, all time series are first high-pass filter with a
; 40-yr filter, although the calibration equation is then applied to raw
; data.
;
thalf=40.
dofilt=1          ; 0=don't high-pass filter, 1=high-pass filter
calper=[1911,1990]
verper=[1856,1910]
;
; Get the density data
;
print,'Restoring MXD data'
restore,'mxd_infill.idlsave'
; Gets: mxdfd2,mxdyear,g and others
nvalues=total(finite(mxdfd2),3)
;
; Get the temperature data
;
print,'Restoring temperature data'
restore,'obs_temp_as.idlsave'
; Gets: timey,fdseas,xlon,ylat,nyri,fdltm and others
; 
; Calibrate grid-box by grid-box
;
print,'Calibrating each grid box',calper
kcalt=where( (timey ge calper(0)) and (timey le calper(1)) , nct )
kcalm=where( (mxdyear ge calper(0)) and (mxdyear le calper(1)) , ncm )
if nct ne ncm then message,'Ooops!'
fdcorr=fltarr(g.nx,g.ny) & fdcorr(*,*)=!values.f_nan
fdalph=fltarr(g.nx,g.ny) & fdalph(*,*)=!values.f_nan
fdbeta=fltarr(g.nx,g.ny) & fdbeta(*,*)=!values.f_nan
fdvexp=fltarr(g.nx,g.ny) & fdvexp(*,*)=!values.f_nan
fdcltm=fltarr(g.nx,g.ny) & fdcltm(*,*)=!values.f_nan
fdcalib=fltarr(g.nx,g.ny,mxdnyr) & fdcalib(*,*,*)=!values.f_nan
i=0
for ix = 0 , g.nx-1 do begin
  for iy = 0 , g.ny-1 do begin
    if finite(fdltm(ix,iy)) and (nvalues(ix,iy) gt 20.) then begin
      onemxd=reform(mxdfd2(ix,iy,*))
      onetem=reform(fdseas(ix,iy,*))
      if dofilt eq 1 then begin
        filter_cru,thalf,/nan,tsin=onemxd,tshigh=mxdhi
        filter_cru,thalf,/nan,tsin=onetem,tshigh=temhi
      endif else begin
        mxdhi=onemxd
        temhi=onetem
      endelse
      mxdhi=mxdhi(kcalm)
      temhi=temhi(kcalt)
      kl=where(finite(mxdhi+temhi),nkeep)
      if nkeep gt 20. then begin
        i=i+1 & print,i,format='($,I4)'
        mxdhi=mxdhi(kl)
        temhi=temhi(kl)
        mkcalibrate,mxdhi,temhi,fitcoeff=fc1,autocoeff=ac1,/matchvar
        fdcorr(ix,iy)=fc1(0)
        fdalph(ix,iy)=fc1(1)
        fdbeta(ix,iy)=fc1(2)
        ltm=total(temhi)/float(nkeep)
        fdcltm(ix,iy)=ltm
        mxdpred=fc1(1)+fc1(2)*mxdhi
        sqvfull=total((temhi-ltm)^2)
        sqvresid=total((temhi-mxdpred)^2)
        fdvexp(ix,iy)=1.-sqvresid/sqvfull
        fdcalib(ix,iy,*)=fc1(1)+fc1(2)*onemxd(*)
      endif
    endif
  endfor
endfor
print
;
; Now verify on a grid-box basis
;
print,'Verifying each grid box',verper
kcalt=where( (timey ge verper(0)) and (timey le verper(1)) , nct )
kcalm=where( (mxdyear ge verper(0)) and (mxdyear le verper(1)) , ncm )
if nct ne ncm then message,'Ooops!'
fdrver=fltarr(g.nx,g.ny) & fdrver(*,*)=!values.f_nan
fdvver=fltarr(g.nx,g.ny) & fdvver(*,*)=!values.f_nan
i=0
for ix = 0 , g.nx-1 do begin
  for iy = 0 , g.ny-1 do begin
    if finite(fdbeta(ix,iy)) then begin
      onemxd=reform(fdcalib(ix,iy,*))
      onetem=reform(fdseas(ix,iy,*))
      mxdhi=onemxd(kcalm)
      temhi=onetem(kcalt)
      kl=where(finite(mxdhi+temhi),nkeep)
      if nkeep gt 9. then begin
        i=i+1 & print,i,format='($,I4)'
        mxdhi=mxdhi(kl)
        temhi=temhi(kl)
        fdrver(ix,iy)=mkcorrelation(mxdhi,temhi)
        mxdpred=fdalph(ix,iy)+fdbeta(ix,iy)*mxdhi
        sqvfull=total((temhi-ltm)^2)
        sqvresid=total((temhi-mxdpred)^2)
        fdvver(ix,iy)=1.-sqvresid/sqvfull
      endif
    endif
  endfor
endfor
print
;
; Now save the data for later analysis
;
save,filename='calibmxd1.idlsave',$
  g,mxdyear,mxdnyr,fdcorr,fdalph,fdbeta,fdvexp,fdcalib,mxdfd2,$
  fdrver,fdvver,fdseas,timey
;
end
