;
; Reads and reformats the Jones et al. land sea mask into an easier format.
;
nx=72
ny=36
lsm=fltarr(nx,ny)
openr,1,'/cru/u2/f055/detect/obsdat/landsea.dat'
readf,1,format='(72I6)',lsm
close,1
lsm=lsm/100.
landonly=lsm*0
landonly(where(lsm eq 1.))=1.
coastl=where((lsm gt 0.25) and (lsm lt 1.),ncoast)
if ncoast gt 0 then landonly(coastl)=7.
coastl=where((lsm gt 0.) and (lsm le 0.25),ncoast)
if ncoast gt 0 then landonly(coastl)=6.
openw,1,'lsmask_jones.dat'
printf,1,'0=ocean    1=land    6=coast (<= 25% land)    7=coast (>25% land)'
printf,1,landonly,format='(72I1)'
close,1
;
end
