;
; Plots regional calibrated hugershoff MXD vs. temperature, blown up for the
; calibration period.
;
doplot=[1,1,1,1,1,0,1,1,1,0]
;
; Get the calibrated MXD and temperature series
;
restore,filename='regtemp_calibrated.idlsave'
; Gets:  nyr,nreg,calregts,regname,timey,tempregts,tempnyr,temptimey
;
; Extract the instrumental period (and remove the ALL/NH region)
;
kmxd=where(timey ge temptimey(0),nmxd)
ktem=where(temptimey le timey(nyr-1),ntem)
if nmxd ne ntem then message,'Oooops!'
calregts=calregts(kmxd,0:nreg-2)
tempregts=tempregts(ktem,0:nreg-2)
temptimey=temptimey(ktem)
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=4
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='red'
def_1color,21,color='green'
;
for ireg = 0 , nreg-1 do begin
 if doplot(ireg) eq 1 then begin
  ;
  pause
  plot,temptimey,calregts(*,ireg),thick=3,$
    /xstyle,xrange=[1850,2000],$
    /ystyle,yrange=[-2.7,2.1],ytitle='Temperature (!Uo!NC wrt 1961-90)',$
    ymargin=[2,0]
  xyouts,1870,1.5,regname(ireg)
  oplot,temptimey,tempregts(*,ireg),thick=3,color=20
  oplot,!x.crange,[0.,0.],linestyle=1
  ;
 endif
endfor
;
end
