;
; Plots regional and large-scale averages of correlations between
; monthly & seasonal precip. and temperature.
;
; Restore all correlations
;
restore,filename='tp_moncorr.idlsave'
;  allr,ncorr,nchron,corrname,statlat,statlon
;
; Restore regional breakdown
;
restore,filename='reg_mxdlists.idlsave'
;  ntree,treelist,nreg,regname
;
; For each region, average the site-by-site correlations together
;
regr=fltarr(nreg,ncorr)
regr95=fltarr(nreg,ncorr,2)
for i = 0 , nreg-1 do begin
  n=ntree(i)
  oner=allr(treelist(0:n-1,i),*)
  totr=total(oner,1)/float(n)
  regr(i,*)=totr(*)
  for icorr = 0 , ncorr-1 do begin
    r1=reform(oner(*,icorr))
    s1=sort(r1)
    regr95(i,icorr,0)=r1(s1(fix(0.05*float(n-1))))
    regr95(i,icorr,1)=r1(s1(fix(0.95*float(n-1))))
  endfor
endfor
;
; Now generate three extra composite regions
;
newr=fltarr(nreg+3,ncorr)
newr95=fltarr(nreg+3,ncorr,2)
newr(0:nreg-1,*)=regr(*,*)
newr95(0:nreg-1,*,*)=regr95(*,*,*)
regname=[regname,'HILAT','LOLAT','NH']
;
rlist=[0,2,3,7,8]
oner=total(regr(rlist,*),1)/float(n_elements(rlist))
oner95=total(regr95(rlist,*,*),1)/float(n_elements(rlist))
newr(nreg,*)=oner(*)
newr95(nreg,*,*)=oner95(*,*)
;
rlist=[1,4,5,6]
oner=total(regr(rlist,*),1)/float(n_elements(rlist))
oner95=total(regr95(rlist,*,*),1)/float(n_elements(rlist))
newr(nreg+1,*)=oner(*)
newr95(nreg+1,*,*)=oner95(*,*)
;
oner=total(regr,1)/float(nreg)
oner95=total(regr95,1)/float(nreg)
newr(nreg+2,*)=oner(*)
newr95(nreg+2,*,*)=oner95(*,*)
;
regr=newr
regr95=newr95
nreg=nreg+3
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2
!p.multi(4)=1
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='vlgrey'
def_1color,21,color='mgrey'
!x.margin=[6,0]
;
tita='('+['a','b']+')'
for i = nreg-3 , nreg-2 do begin
  x=findgen(12)
  y=reform(regr(i,0:11))
  plot,x,y,/nodata,$
    /ystyle,yrange=[-0.65,0.65],ytitle='Correlation',$
    xstyle=5,xrange=[-1,12]
  xyouts,5.5,0.5,tita(i-nreg+3)
  for j = -6 , 6 , 2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
  oplot,!x.crange,[0.,0.]
  cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
  if !d.name eq 'PS' then device,font_size=11
  for j = 0 , 11 do begin
    x1=x(j)+0.25
    y1=y(j)
    if y1 lt 0 then y1=+0.05 else y1=y1+0.05
    y1=-0.7
    xyouts,x1,y1,corrname(j),align=0.,orient=90.
    x1=x(j)
    y1=y(j)
    y1min=regr95(i,j,0)
    y1max=regr95(i,j,1)
;    oplot,x1+[-0.5,0.5],[y1,y1],thick=5
;    plots,x1,y1,psym=def_sym(10)
    oplot,[x1,x1],[y1min,y1max],thick=3
;    plots,x1,y1min,psym=def_sym(12)
;    plots,x1,y1max,psym=def_sym(11)
    oplot,x1+[-0.25,0.25],[y1min,y1min],thick=3
    oplot,x1+[-0.25,0.25],[y1max,y1max],thick=3
  endfor
  if !d.name eq 'PS' then device,font_size=14
endfor
;
end
