;
; Computes rbar for between each region for computation of the MEAN timeseries
;
; Get regional timeseries
;
restore,filename='reglists.idlsave'
nreg=nreg-2      ; NOT ARCTIC or EXTRA-ARCTIC
;
for i = 3 , nreg-1 do begin       ; not 0, 1 & 2 (ALL, NORTH & SOUTH)
  ;
  ; Get adjusted regional timseries
  ;
  restore,filename='densadj_'+regname(i)+'.idlsave'
  ;
  if i eq 3 then begin
    nyr=n_elements(x)
    ndata=nreg-3           ; not 0, 1 & 2
    allmxd=fltarr(nyr,ndata)
  endif
  allmxd(*,i-3)=densadj(*)
  ;
endfor
;
nsize=ndata
inx=allmxd
;
; Define a correlation matrix
;
grandr=fltarr(nsize,nsize)
;
; Do each region against all others (including itself)
;
for j = 0 , nsize-1 do begin
  iny=reform(inx(*,j))
  rowr=manycorr(inx,iny,/nan,nval=nval)     ; compute r values
  grandr(*,j)=rowr(*)
endfor
;
; Total it and average it, but only do i<>j.
;
totr=0.
totn=0.
for j = 1 , nsize-1 do begin
  for k = 0 , j-1 do begin
    if finite(grandr(j,k)) then begin
      totr=totr+grandr(j,k)
      totn=totn+1.
      if grandr(j,k) eq 1. then message,'Ooops!'
    endif
  endfor
endfor
rbar=totr/totn
;
save,filename='rbartd_dens_MEAN.idlsave',rbar,grandr
;
end
