;
restore,filename='reglists.idlsave'
;
; Do a ranking of the adusted MXD timeseries for each region (takes the mean
; of the previous 5 values away first, to try to extract the 'drop').  Also,
; plots this 'drop' timeseries for ALL only.
;
for i = 0 , nreg-1 do begin
  openw,1,'ext_densdrop_'+regname(i)+'.out'
  restore,filename='densadj_'+regname(i)+'.idlsave'
  yall=densadj
  nyr=n_elements(yall)
  ymin=fltarr(nyr)*!values.f_nan
  for j = 5 , nyr-1 do begin
    ymin(j)=total(yall(j-5:j-1))/5.  ; NB any NaN will set this to NaN
  endfor
  densadj=yall-ymin
;
if i eq 0 then begin
  filter_cru,20,tsin=densadj,tslow=tslow,/nan 
  cpl_barts,x,densadj,title='MXD anomaly relative to previous 5 years'+$ 
    ' for region: '+regname(i),xtitle='Year',/xstyle,$ 
    zeroline=tslow,yrange=[-8,4]
  oplot,x,tslow,thick=2 
  oplot,!x.crange,[0.,0.]
  oplot,!x.crange,[-2.,-2.],linestyle=1
endif
;
  keeplist=where(finite(densadj),nkeep)
  y=densadj(keeplist)
  x=x(keeplist)
  slist=sort(y)
  printf,1,'Extremes of MXD anomalies relative to previous 5 years for region: '+$
      regname(i)
  printf,1,' Low extremes                     | High extremes'
  printf,1,' Rank Year   Density              | Rank Year   Density          '
  for j = 0 , 59 do begin
    k=nkeep-j-1
    printf,1,j+1,x(slist(j)),y(slist(j)),$
          k+1,x(slist(k)),y(slist(k)),$
          format='(2I5,F10.4,9X,6X,2I5,F10.4,10X)'
  endfor
  close,1
endfor
;
end
