;
restore,filename='reglists.idlsave'
regname=regname(3:nreg-1)             ; not 0,1,2 (ALL, N & S)
regname=[regname,'MEAN']
nreg=n_elements(regname)
;
; Do a ranking of the adusted MXD timeseries for each region
;
for i = 0 , nreg-1 do begin
  openw,1,'ext_dens_'+regname(i)+'.out'
  restore,filename='densadj_'+regname(i)+'.idlsave'
  keeplist=where(finite(densadj),nkeep)
  y=densadj(keeplist)
  x=x(keeplist)
  slist=sort(y)
  printf,1,'Extremes of normalised MXD anomalies for region: '+$
      regname(i)
  printf,1,' Low extremes                     | High extremes'
  printf,1,' Rank Year   Density              | Rank Year   Density          '
  for j = 0 , 59 do begin
    k=nkeep-j-1
    printf,1,j+1,x(slist(j)),y(slist(j)),$
          k+1,x(slist(k)),y(slist(k)),$
          format='(2I5,F10.4,9X,6X,2I5,F10.4,10X)'
  endfor
  close,1
endfor
;
end
