;
;openw,1,'ts_ALL.out'
openw,1,'ts_MEAN.out'
  ;
  ; Get data in
  ;
  restore,filename='densadj_MEAN.idlsave'
  ;restore,filename='densadj_ALL.idlsave'
  nyr=n_elements(densadj)
  ;
  ; Do ranking over available data
  ;
  keeplist=where(finite(densadj),nkeep)
  v1=densadj(keeplist)
  s1=sort(v1)
  rank1=intarr(nyr)-999
  k=0
  for j = 0 , nyr-1 do begin
    if finite(densadj(j)) then begin
      rank1(j)=where(s1 eq k)+1
      k=k+1
    endif
  endfor
  ;
  ; Set to missing flag
  ;
  missval=-9.999
  misslist=where(finite(densadj) eq 0,nmiss)
  if nmiss gt 0 then densadj(misslist)=missval
  ;
  ; Output it
  ;
  printf,1,'MXD timeseries (variance-adjusted & normalised over 1881-1960)'+$
;    ' for ALL'
    ' for MEAN'
  printf,1,'        MXD   MXD'
  printf,1,' Year   Rank  Anomaly'
  for j = 0 , nyr-1 do printf,1,x(j),rank1(j),densadj(j),$
          format='(I5,"  ",I5,F9.3)'
  close,1
;
end
