function linkmask,modname
;
; Returns land-sea mask for a model (0=sea, 1=land)
;
case strlowcase(modname) of
  'hadcm2': begin
     fn='/cru/u2/f055/idllib_f055/link/datastore/orog_hadcm2.dat'
     nhead=6
     nx=96
     ny=73
     fform='(8F8.1)'
     seaval=0.
     end
  'hadcm3': begin
     fn='/cru/u2/f055/idllib_f055/link/datastore/orog_hadcm2.dat'
     nhead=6
     nx=96
     ny=73
     fform='(8F8.1)'
     seaval=0.
     end
  else: message,'Can not find land-sea mask for model '+modname
endcase
;
openr,lun,/get_lun,fn
headst=strarr(nhead)
readf,lun,headst
lsmask=fltarr(nx,ny)
readf,lun,lsmask,format=fform
close,lun
;
outfd=fltarr(nx,ny)+1.
sealist=where(lsmask eq seaval,nsea)
if nsea gt 0 then outfd(sealist)=0.
;
return,outfd
;
end
