;
; Outputs regional timeseries
;
; Get region info
;
restore,filename='reglists.idlsave'
regfn=['all','n60','s60','wna','ena','cer','neu','seu']
missval=-99.9999
;
; For each region
;
for ireg = 0 , nreg-1 do begin
  ;
  ; Get adjusted density timeseries, adjusted width and actual temperatures
  ;
  restore,filename='densadj_'+regname(ireg)+'.idlsave'
  restore,filename='rwidadj_'+regname(ireg)+'.idlsave'
  restore,filename='instrts_'+regname(ireg)+'.idlsave'
  nt=n_elements(x)
  ;
  misslist=where(finite(densadj) eq 0,nmiss)
  if nmiss gt 0 then densadj(misslist)=missval
  ;
  misslist=where(finite(rwidadj) eq 0,nmiss)
  if nmiss gt 0 then rwidadj(misslist)=missval
  ;
  misslist=where(finite(winstr) eq 0,nmiss)
  if nmiss gt 0 then winstr(misslist)=missval
  ;
  openw,1,regfn(ireg)+'_tdwi.dat'
  printf,1,regname(ireg),format='(A15,5X,"Region name")'
  printf,1,nt,format='(I5,15X,"Number of years")'
  printf,1,missval,format='(F9.4,11X,"Missing value")'
  printf,1,' Year  Density    Width    April      May     June     July   August     Sept'
  for iyr = 0 , nt-1 do begin
    printf,1,x(iyr),densadj(iyr),rwidadj(iyr),reform(winstr(iyr,3:8)),$
      format='(I5,8F9.4)'
  endfor
  close,1
  ;
  openw,1,regfn(ireg)+'_temp.dat'
  printf,1,regname(ireg),format='(A15,5X,"Region name")'
  printf,1,nt,format='(I5,15X,"Number of years")'
  printf,1,missval,format='(F9.4,11X,"Missing value")'
  printf,1,' Year  Jan-Dec'
  for iyr = 256 , nt-1 do begin
    printf,1,x(iyr),reform(winstr(iyr,0:11)),$
      format='(I5,12F9.4)'
  endfor
  close,1
  ;
endfor
;
end
