;
; Computes lagged correlations between monthly instrumental data (regional
; means variance-adjusted but fixed grid) and density and width regional
; series.
;
perst=1881.
peren=1960.
;
; Get region info and rbar for each region
;
restore,filename='regboxes.idlsave'
crs=fltarr(nreg,2,20)           ; 2=variables (mxd/trw), 19=months+seasons
restore,filename='rbar_monthly.idlsave'
for ireg = 0 , nreg-1 do begin
  ;
  print,regname(ireg)
  print,'Reading in regional data'
  ;
  restore,filename='densadj_'+regname(ireg)+'.idlsave'
  y1=densadj
  restore,filename='rwidadj_'+regname(ireg)+'.idlsave'
  y2=rwidadj
  restore,filename='nc.instrts_'+regname(ireg)+'.idlsave'
  ;
  for i = 0 , 11 do begin
    print,'Computing monthly instrumental timeseries',i
    onets=reform(winstr(*,i))
    onecover=reform(wcover(*,i))
    oneadj=mkeffective(onets,onecover,rbar=monrbar(ireg,i))
    mknormal,oneadj,x,refperiod=[1881,1950]
    onelag=shift(oneadj,1)
    onelag(0)=!values.f_nan
    ;
    print,'Computing correlations'
    if i ge 5 then begin
keeplist=where(finite(y1+y2+onelag) and (x ge perst) and (x le peren),nkeep)
      ts1=y1(keeplist)
      ts2=y2(keeplist)
      ts3=onelag(keeplist)
      r1lag=correlate(ts1,ts3)
      r2lag=correlate(ts2,ts3)
      print,r1lag,r2lag
      crs(ireg,0,i-5)=r1lag
      crs(ireg,1,i-5)=r2lag
    endif
    if i le 9 then begin
keeplist=where(finite(y1+y2+oneadj) and (x ge perst) and (x le peren),nkeep)
      ts1=y1(keeplist)
      ts2=y2(keeplist)
      ts3=oneadj(keeplist)
      r1=correlate(ts1,ts3)
      r2=correlate(ts2,ts3)
      print,r1,r2
      crs(ireg,0,i+7)=r1
      crs(ireg,1,i+7)=r2
    endif
    ;
  endfor
  ;
  print,'Apr-Sep'
  totval=total(winstr(*,3:8),2,/nan)
  totn=total(finite(winstr(*,3:8)),2)
  keeplist=where(totn gt 0,nkeep)
  wdens=totval*!values.f_nan
  wdens(keeplist)=totval(keeplist)/float(totn(keeplist))
  totcover=total(wcover(*,3:8),2)/6.      ; compute mean no. of boxes with data
  xadj=mkeffective(wdens,totcover,rbar=amjjasrbar(ireg))
  mknormal,xadj,x,refperiod=[1881,1950]
  amjjasts=xadj
  ;
keeplist=where(finite(y1+y2+amjjasts) and (x ge perst) and (x le peren),nkeep)
  ts1=y1(keeplist)
  ts2=y2(keeplist)
  ts3=amjjasts(keeplist)
  r1=correlate(ts1,ts3)
  r2=correlate(ts2,ts3)
  print,r1,r2
  crs(ireg,0,17)=r1
  crs(ireg,1,17)=r2
  ;
  print,'May-Aug'
  totval=total(winstr(*,4:7),2,/nan)
  totn=total(finite(winstr(*,4:7)),2)
  keeplist=where(totn gt 0,nkeep)
  wdens=totval*!values.f_nan
  wdens(keeplist)=totval(keeplist)/float(totn(keeplist))
  totcover=total(wcover(*,4:7),2)/4.      ; compute mean no. of boxes with data
;****************** SHOULD USE MJJARBAR WHEN IT'S COMPUTED!*************
  xadj=mkeffective(wdens,totcover,rbar=mjjarbar(ireg))
  mknormal,xadj,x,refperiod=[1881,1950]
  mjjats=xadj
  ;
keeplist=where(finite(y1+y2+mjjats) and (x ge perst) and (x le peren),nkeep)
  ts1=y1(keeplist)
  ts2=y2(keeplist)
  ts3=mjjats(keeplist)
  r1=correlate(ts1,ts3)
  r2=correlate(ts2,ts3)
  print,r1,r2
  crs(ireg,0,18)=r1
  crs(ireg,1,18)=r2
  ;
  print,'Jun-Jul'
  totval=total(winstr(*,5:6),2,/nan)
  totn=total(finite(winstr(*,5:6)),2)
  keeplist=where(totn gt 0,nkeep)
  wdens=totval*!values.f_nan
  wdens(keeplist)=totval(keeplist)/float(totn(keeplist))
  totcover=total(wcover(*,5:6),2)/2.      ; compute mean no. of boxes with data
  xadj=mkeffective(wdens,totcover,rbar=jjrbar(ireg))
  mknormal,xadj,x,refperiod=[1881,1950]
  jjts=xadj
  ;
keeplist=where(finite(y1+y2+jjts) and (x ge perst) and (x le peren),nkeep)
  ts1=y1(keeplist)
  ts2=y2(keeplist)
  ts3=jjts(keeplist)
  r1=correlate(ts1,ts3)
  r2=correlate(ts2,ts3)
  print,r1,r2
  crs(ireg,0,19)=r1
  crs(ireg,1,19)=r2
  ;
endfor
;
print,' '
print,'Correlations carried out over the period ',perst,peren
;
; Now plot correlation bar charts
;
loadct,0
def_1color,r,g,b,10,color='dred'
def_1color,r,g,b,11,color='dgreen'
plot,[0,1]
multi_plot,nrow=4
if !d.name eq 'X' then window,ysize=800
;
yr=[-0.5,1.]
;cols=[100.,200.]*(!d.n_colors-1)/255.
cols=[10,11]
labels=['j','j','a','s','o','n','d','J','F','M','A','M','J',$
  'J','A','S','O','A-S','M-A','J-J']
;
for ireg = 0 , nreg-1 do begin
  dd=reform(crs(ireg,*,*))
  pause
  plot_record,dd,yrange=yr,cols=cols,labels=labels,ygap=0.1,$
    title=regname(ireg)
endfor
;
end
