;
; Plots precipitation changes from 1921-50 to 1961-85
; for growing season AMJJAS
;
; 1) IPCC temperature anomalies first
;
per1=[1921,1950]
per2=[1961,1985]
;
print,'Reading in IPCC air/ss temp gridded data' 
ncid=ncdf_open('/cru/dave3/f055/data/obs/grid/surface/precip_19001995.mon.nc') 
print,per1
fd1=crunc_rddata(ncid,tst=[per1(0),0],tend=[per1(1),11],grid=g1,info=i) 
print,per2
fd2=crunc_rddata(ncid,tst=[per2(0),0],tend=[per2(1),11],grid=g2,info=i) 
ncdf_close,ncid
;
; Convert to growing season mean and long term mean, all in one go
; Each box must have at least 60% of the monthly values
;
print,'Converting to seasons'
; Extract Apr-Sep only
kl=where( (g1.month ge 3) and (g1.month le 8) , nk1 )
fd1=fd1(*,*,kl)
nmax1=g1.nt*0.5                ; number of months is halved by this extraction
kl=where( (g2.month ge 3) and (g2.month le 8) , nk2 )
fd2=fd2(*,*,kl)
nmax2=g2.nt*0.5
print,nmax1,nmax2,nk1,nk2
; Total the available values, count the finite ones, and compute the mean
fdtot1=total(fd1,3,/nan)
fdnum1=total(finite(fd1),3)
fdmean1=fdtot1/float(fdnum1)
fdtot2=total(fd2,3,/nan)
fdnum2=total(finite(fd2),3)
fdmean2=fdtot2/float(fdnum2)
; Mask out any that had less than 60% availability
ml=where(fdnum1 lt nmax1*0.6,nmiss)
if nmiss gt 0 then fdmean1(ml)=!values.f_nan
ml=where(fdnum2 lt nmax2*0.6,nmiss)
if nmiss gt 0 then fdmean2(ml)=!values.f_nan
;
; Now ratio them
;
print,'Computing the temperature change'
precdiff=fdmean2/fdmean1
g=g1
;
save,filename='pchange.idlsave',precdiff,g
;
end
