;
; Computes lists of grid-boxes in each of HARRY'S regions
;
;----------------------------------------------------
;
; Get IPCC instrumental dataset grid
;
g=def_grid(/ipcc)
;
; Define arrays to use
;
nreg=9
regname=strarr(nreg)
boxlists=fltarr(g.nx,g.ny,nreg)
;
; Now process each region in turn
;
openr,1,'/cru/keith1/harry/trees/neworder/ninelist.scr'
dummy=' '
readf,1,dummy
;
for i = 0 , nreg-1 do begin
  ;
  ; Get chronology locations
  ;
  readf,1,n,dummy,format='(I4,A76)'
  print,n,dummy,format='(I4,2X,A70)'
  regname(i)=dummy
  rawdat=fltarr(2,n)
  readf,1,rawdat,format='(I5,1X,I6)'
  rawdat=rawdat/100.
  ylat=reform(rawdat(0,*))
  xlon=reform(rawdat(1,*))
  ;
  ; Now locate the boxes with data in
  ;
  statval=fltarr(n)+1.
  fdout=gridit(g.nx,g.ny,g.x,g.y,xlon,ylat,statval)
  boxlists(*,*,i)=fdout(*,*)
  ;
endfor
;
close,1
;
regname=strcompress(regname)
save,filename='harryboxes.idlsave',nreg,boxlists,regname
;
end
