;
; Reads Harry's regional timeseries and outputs the 1500-1992 portion
; with missing values set appropriately.  Uses mxd, and just the
; "2nd-6th band" and "all band" timeseries
;
loadct,39
plot,[0,1]
multi_plot,nrow=4
if !d.name eq 'X' then begin
  window,ysize=900
  initx
endif else begin
  device,xoffset=2,xsize=17
endelse
;
; Get regional tree lists and rbar
;
restore,filename='reglists.idlsave'
harryfn=['nwcan','wnam','cecan','nweur','sweur','nsib','csib','tib',$
  'esib','allsites']
;
rawdat=fltarr(4,2000)
;for i = 0 , nreg-1 do begin
for i = nreg-1 , nreg-1 do begin
;  fn='mxd.'+harryfn(i)+'.pa.mean.dat'
  fn='mxd.'+harryfn(i)+'.sa.mean.dat'
  print,fn
  openr,1,fn
  readf,1,rawdat
  close,1
  ;
  densadj=reform(rawdat(2:3,*))
  ml=where(densadj eq -99.999,nmiss)
  densadj(ml)=!values.f_nan
  ;
  x=reform(rawdat(0,*))
  kl=where((x ge 1400) and (x le 1995))
  x=x(kl)
;  densall=densadj(1,kl)     ; all bands
;  densadj=densadj(0,kl)     ; 2-6 bands
  densall=densadj(0,kl)     ; all bands
  densadj=densadj(1,kl)     ; 2-6 bands
  ;
  ; Now normalise w.r.t. 1901-1940
  ;
  mknormal,densadj,x,refperiod=[1901,1940],refmean=refmean,refsd=refsd
  mknormal,densall,x,refperiod=[1901,1940],refmean=refmean,refsd=refsd
  ;
  ; Now plot them
  ;
  pause
  filter_cru,20,tsin=densadj,tslow=tslow,/nan 
  cpl_barts,x,densadj,title='Weighted mean normalised max density anomaly'+$ 
    ' for region: '+regname(i),xtitle='Year',/xstyle,$ 
    zeroline=tslow,yrange=[-8,4]
  oplot,x,tslow,thick=2 
  filter_cru,20,tsin=densall,tslow=tslow,/nan 
  oplot,x,tslow,color=200
  oplot,!x.crange,[0.,0.]
  ;
  ; Now save the weighted mean timeseries, for further analysis
  ;
  save,filename='densadj_'+regname(i)+'.idlsave',x,densadj,densall
  ;
endfor
;
end
