! pattscale.f90
! module procedure written by Tim Mitchell
! includes subroutines necessary for pattern scaling to equilibrium

module PattScale

implicit none

contains

!*******************************************************************************

subroutine GetKaySet (KaySet,Forc2co2,FitAlpha,FitBeta,Sens2co2Init,TrendTLen)

real, intent(out) 		:: Forc2co2,FitAlpha,FitBeta,Sens2co2Init

integer, intent(in) 		:: KaySet				! may be MissVal or zero or >=1
integer, intent(out) 		:: TrendTLen		

real, parameter :: MissVal = -999.0

integer :: AllocStat,ReadStatus
integer :: QKaySet

!***************************************

if (KaySet.EQ. 0) then					! allow selection of QKaySet if required
    print*, "  > These are the available sets of constants: "
    print*, "  >  1 : 3.47, 1.3388, -96.613, 1.9, 100"
    do
	read (*,*,iostat=ReadStatus), QKaySet
	if (ReadStatus.LE.0.AND.QKaySet.GE.1.AND.QKaySet.LE.1) exit
    end do
else
    QKaySet = KaySet
end if
    
if (QKaySet.EQ. 1) then					! allow designation of constants if possible
    Forc2co2=3.47 ; FitAlpha=1.3388 ; FitBeta=-96.613 ; Sens2co2Init=1.9 ; TrendTLen=100
else
    QKaySet = MissVal
end if

if (KaySet.EQ.MissVal) then				! designate constants individually
    print*, "  > Enter the radiative forcing for a doubling of CO2: "
    do
	read (*,*,iostat=ReadStatus), Forc2co2
	if (ReadStatus.LE.0.AND.Forc2co2.GT.0) exit
    end do
    print*, "  > Enter the alpha and beta parameters for dS/dT=alpha*e(beta*dT/dt): "
    do
	read (*,*,iostat=ReadStatus), FitAlpha, FitBeta
	if (ReadStatus.LE.0) exit
    end do
    print*, "  > Enter the initial climate sensitivity for a doubling of CO2: "
    do
	read (*,*,iostat=ReadStatus), Sens2co2Init
	if (ReadStatus.LE.0.AND.Sens2co2Init.GT.0) exit
    end do
    print*, "  > Enter the period length over which to calc dT/dt: "
    do
	read (*,*,iostat=ReadStatus), TrendTLen
	if (ReadStatus.LE.0.AND.TrendTLen.GT.0) exit
    end do
end if

end subroutine GetKaySet

!*******************************************************************************

end module PattScale
