; input is model chosen and the last plot view boundaries
; interrogates mouse
; if right (=4) or centre (=2) button is pressed, returns integer in Button
; if left (=1) is pressed, checks that lat and long are within view boundaries (i.e. not on another plot)
; if so, converts into XLong (Exe) and XLat (Wye) and returns also with integer in Button

pro UseMouse, ViewBounds, ModelChosen, Exe, Wye, Button, Loud=Loud

MissVal = -999.0
ExeCoord = MissVal &	WyeCoord = MissVal
Exe = -1 & 		Wye = -1 &		Button = -1
CheckReturn = 0

while (CheckReturn EQ 0) do begin
      !Err = 0
      
      while (!Err EQ 0) do begin
          cursor, ExeCoord, WyeCoord, /down
      endwhile
      
      if            (!Err EQ 2 OR !Err EQ 4) then begin		; right or middle button
          Button = !Err
      	  CheckReturn = 1
      endif else if (!Err EQ 1)              then begin		; left button
        							; ViewBounds = lonmin, lonmax, latmin, latmax
        if   (ExeCoord GE ViewBounds[0] AND ExeCoord LE ViewBounds [1]  AND $
              WyeCoord GE ViewBounds[2] AND WyeCoord LE ViewBounds [3]) then begin
          
          CoordToBox, ModelChosen, ExeCoord, WyeCoord, Exe, Wye          	  
          Button = !Err
          CheckReturn = 1
        endif
        
      endif    
endwhile

if (keyword_set(Loud) AND Button EQ 1) then print, ExeCoord,WyeCoord,Exe,Wye,format="(2f8.2,2i5)" 

end
