; loads colour table appropriate to specified variable 
; input: the information vector
; input: the number of contours to plot per tick segment
; colour table: 0=black,1-253=colours,254=grey,255=white
; output: DataBounds(a,b) correspond to colours 1,253
; output: number of contours 
; output: the values at which to place tick marks
; output: the format in which to plot the tick labels

pro LoadVariCT, Info, ContourFactor, DataBounds, ContourN, TickVals, TickFormat, SeasIndex=SeasIndex

MissVal = -999.0
Real0 = 0.0D & Real1 = 0.0D
DataBounds = dblarr (2) & DataBounds = MissVal
ColFile = "" & TickFormat = ""
SegGap = 1.0

Variable = -1
if (Info[0] EQ 'cloud cover') 	then Variable = 0
if (Info[0] EQ 'DTR') 		then Variable = 1

if (Info[0] EQ 'precipitation') then begin
  if (Info[3] EQ 'mm') 		then Variable = 2
  if (Info[3] EQ 'mm/day') 	then Variable = 3
  if (Info[3] EQ 'percentage') 	then Variable = 4
endif

if (Info[0] EQ 'temperature') 	then Variable = 5
if (Info[0] EQ 'vapour pressure')  then Variable = 6
if (Info[0] EQ 'elevation')     then Variable = 7
if (Info[0] EQ 'constant')      then Variable = 8
if (Info[0] EQ 'koeppen')      	then Variable = 9
if (Info[0] EQ 'count')      	then Variable = 10
if (Info[0] EQ 'wet days')      then Variable = 11
if (Info[0] EQ 'frost days')    then Variable = 12
if (Info[0] EQ 'sunshine')      then Variable = 13
if (Variable EQ -1) then print, "  > ##### ERROR: LoadVariCT: Info[0] not recognised #####"

Statistic = -1
if (Info[1] EQ 'mean') 		then Statistic = 0
if (Info[1] EQ 'response') 	then Statistic = 1
if (Info[1] EQ 'anomaly') 	then Statistic = 2
if (Info[1] EQ 'difference') 	then Statistic = 3
if (Info[1] EQ 'anomalyPC') 	then Statistic = 4
if (Statistic EQ -1) then print, "  > ##### ERROR: LoadVariCT: Info[1] not recognised #####"

if (keyword_set(SeasIndex)) then begin
  XSeason = SeasIndex
endif else begin
  XSeason = 17
endelse  
   
if            (Variable EQ 0) then begin			; cloud cover
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/reverse-b+w.dat'
    DataBounds = [0.0,50.0]
    SegGap = 5.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/cld.ano.dat'
    DataBounds = [-5.0,5.0]
    SegGap = 1.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/cld.ano.dat'
    DataBounds = [-10.0,10.0]
    SegGap = 2.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/cld.ano.dat'
    DataBounds = [-1.0,1.0]
    SegGap = 0.2
    TickFormat = "(f4.1)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/cld.ano.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 1) then begin			; DTR
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/dtr.abs.dat'
    DataBounds = [0.0,20.0]
    SegGap = 2.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/dtr.ano.dat'
    DataBounds = [-0.4,0.4]
    SegGap = 0.1
    TickFormat = "(f4.1)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/dtr.ano.dat'
    DataBounds = [-2.0,2.0]
    SegGap = 1.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/dtr.ano.dat'
    DataBounds = [-1.0,1.0]
    SegGap = 0.2
    TickFormat = "(f4.1)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/dtr.ano.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 2) then begin			; precip mm
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.abs3.dat'
    if            (XSeason GE 1 AND XSeason LE 12) then begin
      DataBounds = [0.0,200.0]
      SegGap = 20.0
      TickFormat = "(i3)"
    endif else if (XSeason GE 13 AND XSeason LE 16) then begin
      DataBounds = [0.0,600.0]
      SegGap = 100.0
      TickFormat = "(i3)"
    endif else if (XSeason GE 17 AND XSeason LE 17) then begin
      DataBounds = [0.0,2000.0]
      SegGap = 200.0
      TickFormat = "(i4)"
    endif
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    if            (XSeason GE 1 AND XSeason LE 12) then begin
      DataBounds = [-50.0,50.0]
      SegGap = 10.0
      TickFormat = "(i3)"
    endif else if (XSeason GE 13 AND XSeason LE 16) then begin
      DataBounds = [-10.0,10.0]
      SegGap = 2.0
      TickFormat = "(i3)"
    endif else if (XSeason GE 17 AND XSeason LE 17) then begin
      DataBounds = [-10.0,10.0]
      SegGap = 2.0
      TickFormat = "(i3)"
    endif
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    if            (XSeason GE 1 AND XSeason LE 12) then begin
      DataBounds = [-100.0,100.0]
      SegGap = 20.0
      TickFormat = "(i4)"
    endif else if (XSeason GE 13 AND XSeason LE 16) then begin
      DataBounds = [-300.0,300.0]
      SegGap = 100.0
      TickFormat = "(i4)"
    endif else if (XSeason GE 17 AND XSeason LE 17) then begin
      DataBounds = [-50,50.0]
      SegGap = 10.0
      TickFormat = "(i3)"
    endif
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    if            (XSeason GE 1 AND XSeason LE 12) then begin
      DataBounds = [-10.0,10.0]
      SegGap = 2.0
      TickFormat = "(i3)"
    endif else if (XSeason GE 13 AND XSeason LE 16) then begin
      DataBounds = [-10.0,10.0]
      SegGap = 20.0
      TickFormat = "(i3)"
    endif else if (XSeason GE 17 AND XSeason LE 17) then begin
      DataBounds = [-10.0,10.0]
      SegGap = 2.0
      TickFormat = "(i3)"
    endif
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 3) then begin			; precip mm/day
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.abs3.dat'
    DataBounds = [0.0,5.0]
    SegGap = 0.5
    TickFormat = "(f3.1)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-0.2,0.2]
    SegGap = 0.05
    TickFormat = "(f5.2)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-2.0,2.0]
    SegGap = 0.5
    TickFormat = "(f4.1)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-0.05,0.05]
    SegGap = 0.01
    TickFormat = "(f5.2)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 4) then begin			; precip percent
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.abs3.dat'
    DataBounds = [0.0,200.0]
    SegGap = 20.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-10.0,10.0]
    SegGap = 2.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-25.0,25.0]
    SegGap = 5.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 5) then begin			; temperature
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.abs3.dat'
    DataBounds = [-50.0,40.0]
    SegGap = 10.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-3.0,3.0]
    SegGap = 1.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-5.0,5.0]
    SegGap = 1.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-0.1,0.1]
    SegGap = 0.02
    TickFormat = "(f5.2)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 6) then begin			; vapour pressure
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/vap.abs.dat'
    DataBounds = [0.0,20.0]
    SegGap = 2.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/vap.ano.dat'
    DataBounds = [-2.0,2.0]
    SegGap = 0.4
    TickFormat = "(f4.1)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/vap.ano.dat'
    DataBounds = [-2.0,2.0]
    SegGap = 0.5
    TickFormat = "(f4.1)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/vap.ano.dat'
    DataBounds = [-0.2,0.2]
    SegGap = 0.05
    TickFormat = "(f5.2)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/vap.ano.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 7) then begin			; elevation
  ColFile = '/cru/tyn1/f709762/idlcolours/pre.abs3.dat'
  DataBounds = [0.0,2000.0]
  SegGap = 200.0
  TickFormat = "(i4)"
endif else if (Variable EQ 8) then begin			; constant
  ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano.dat'
  DataBounds = [0.0,1.0]
  SegGap = 0.1
  TickFormat = "(f3.1)"
endif else if (Variable EQ 9) then begin			; Koeppen
  ColFile = '/cru/tyn1/f709762/idlcolours/tmp.abs3.dat'
  DataBounds = [0,100]
  SegGap = 10
  TickFormat = "(i3)"
endif else if (Variable EQ 10) then begin			; count
  ColFile = '/cru/tyn1/f709762/idlcolours/tmp.half.dat'
  DataBounds = [0,100]
  SegGap = 10
  TickFormat = "(i3)"
endif else if (Variable EQ 11 OR Variable EQ 12) then begin	; wet/frs days
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.abs3.dat'
    DataBounds = [0.0,30.0]
    SegGap = 3.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-1.0,1.0]
    SegGap = 0.2
    TickFormat = "(f4.1)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-10.0,10.0]
    SegGap = 1.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-10.0,10.0]
    SegGap = 1.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/pre.ano2.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif else if (Variable EQ 13) then begin			; sunshine %
  if            (Statistic EQ 0) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.abs3.dat'
    DataBounds = [0.0,100.0]
    SegGap = 10.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 1) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-3.0,3.0]
    SegGap = 1.0
    TickFormat = "(i2)"
  endif else if (Statistic EQ 2) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-20.0,20.0]
    SegGap = 5.0
    TickFormat = "(i3)"
  endif else if (Statistic EQ 3) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-0.1,0.1]
    SegGap = 0.02
    TickFormat = "(f5.2)"
  endif else if (Statistic EQ 4) then begin
    ColFile = '/cru/tyn1/f709762/idlcolours/tmp.ano3.dat'
    DataBounds = [-100.0,100.0]
    SegGap = 20.0
    TickFormat = "(i4)"
  endif
endif

if (ColFile EQ "") then begin  
    print, "  > Enter the colour table file (/cru/tyn1/f709762/idlcolours/): "
    read, ColFile

    print, "  > Enter the min,max of the data range: "                                  ; min,max match 1,253
    read, Real0, Real1
    DataBounds[0] = Real0 & DataBounds[1] = Real1

    print, "  > Enter the gap between scale labels: "
    read, SegGap

    print, "  > Enter the format of the tick labels: "
    read, TickFormat
endif

Red   = intarr (255)
Green = intarr (255)
Blue  = intarr (255)

openr, lunCol, ColFile, /get_lun
for XCol = 0, 254 do begin
      readf, lunCol, DatumInt1, DatumInt2, DatumInt3
      Red  [XCol] = DatumInt1
      Green[XCol] = DatumInt2
      Blue [XCol] = DatumInt3
endfor
free_lun, lunCol
    
tvlct, Red, Green, Blue

tvlct,   0,   0,   0,   0		; black
tvlct, 200, 200, 200, 254		;  grey
tvlct, 255, 255, 255, 255		; white

ContourGap = float(SegGap) / ContourFactor

TickN = fix ((DataBounds[1]-DataBounds[0]) / float(SegGap)) + 1

TickVals = fltarr (TickN)
for XTick = 0, (TickN-1) do begin
  TickVals[XTick] = DataBounds[0] + (float(XTick)*float(SegGap))
endfor 

if (DataBounds[0] NE 0.0) then DataBounds[0] = DataBounds[0] - ContourGap

ContourN = fix((DataBounds[1]-DataBounds[0]) / ContourGap) + 1

end
