; provides contours and colours for drawing on plots: Contours, ContourColours
; input = vector of scale and colour limits: Limits
; input = number of segments in scale

pro GetContours,DataBounds,ColourBounds,Contours,ContourColours,ContourN,Log=Log

ContourColours = dblarr (ContourN)
Contours       = dblarr (ContourN)

ColourIncrement = (float(ColourBounds[1]) - float(ColourBounds[0])) / float(ContourN-1) 
for XUnit = 0, (ContourN-1) do begin
       ContourColours [XUnit] = ColourBounds [0] + (XUnit * ColourIncrement)
endfor

if (keyword_set(Log) AND DataBounds[0] GT 0) then begin
  LogMin=alog10(float(DataBounds[0])) & LogMax=alog10(float(DataBounds[1]))
  LevelIncrement  = (LogMax - LogMin) / float(ContourN-1)
  for XUnit = 0, (ContourN-1) do begin
    Contours [XUnit] = 10 ^ (LogMin + (LevelIncrement*XUnit))
  endfor
endif else begin 
  LevelIncrement  = (DataBounds[1] - DataBounds[0]) / float(ContourN-1)
  for XUnit = 0, (ContourN-1) do begin
    Contours [XUnit] = DataBounds[0] + (XUnit * LevelIncrement)       
  endfor
endelse
      
end
