; draws key for plotcontour.pro
; scale always plotted, 
; QBarInfo = none (=0), all (=1), attrib(=2), info (=3)

pro DrawConScale,ScaleCorners,Contours,ContourColors,TickVals,TickFormat, $
	TextSize,TextThick,Info,XPixels,YPixels,QBarInfo,Log=Log

DimContour = size (Contours)
ContourN = DimContour [1]

ExeBegPix = (ScaleCorners [0] + 0.01) * XPixels * 1000		; start point of all
  
LogoFactor = 4.0						; Tyndall logo dimensions
LogoPixX = 834.0 * LogoFactor
LogoPixY = 184.0 * LogoFactor

RowPixY = 350.0	* TextSize					; text row height
TopDownPix = ((ScaleCorners[3] - 0.01)*YPixels*1000)

if (QBarInfo EQ 1 OR QBarInfo EQ 2) then begin		 	; draw logo
  WyeLogoPix = TopDownPix - LogoPixY
  
  read_jpeg, '/cru/u2/f709762/goglo/ref/tyn-logo-torok.jpg', $
  		Logo, LogoCT, colors=256, dither=1, /two_pass_quantize
  tvlct, Red,Green,Blue, /get					; get old colors
  tvlct, LogoCT(*,0), LogoCT(*,1), LogoCT(*,2)
  tv, Logo, ExeBegPix, WyeLogoPix, xsize=LogoPixX, ysize=LogoPixY, /device
  tvlct, Red,Green,Blue						; restore old colors
  
  TopDownPix = WyeLogoPix - RowPixY
endif

if (QBarInfo EQ 1 OR QBarInfo EQ 2) then begin			; author stamp
  Author = "Tim Mitchell"
  xyouts, ExeBegPix, TopDownPix, Author, font=5, charsize=TextSize, $
  			charthick=TextThick, /device
  TopDownPix = TopDownPix - RowPixY
endif

if (QBarInfo EQ 1 OR QBarInfo EQ 2) then begin			; date stamp
  DateTime  = systime ()
  DateStamp = strmid(DateTime,4,7) + strmid(DateTime,20,4)
  xyouts, ExeBegPix, TopDownPix, DateStamp, font=5, charsize=TextSize, $
  			charthick=TextThick, /device
  TopDownPix = TopDownPix - RowPixY
endif
								; separate logo etc from rest
if (QBarInfo EQ 1 OR QBarInfo EQ 2) then $
	TopDownPix = TopDownPix - RowPixY

BottUpPix = ((ScaleCorners[1] + 0.01)*YPixels*1000)

if (QBarInfo EQ 1 OR QBarInfo EQ 3) then begin			; information
  for XInfo = 9, 0, -1 do begin
   if (Info(XInfo) NE 'missing') then begin
    InfoItself = Info[XInfo]
    if (InfoItself EQ 'anomalyPC') then InfoItself = 'anomaly'
    GiveSymbol, InfoItself
    xyouts, ExeBegPix, BottUpPix, InfoItself, font=5, charsize=TextSize, $
    		charthick=TextThick, /device
    BottUpPix = BottUpPix + RowPixY
   endif  
  endfor		

  BottUpPix = BottUpPix + RowPixY
endif

if (QBarInfo GE 0) then begin					; scale
  BarCorners = [ExeBegPix,BottUpPix,(ExeBegPix+250),TopDownPix]
  
  DotsToPlot = dblarr (2,(ContourN+1))
  DotsToPlot [0,0:(ContourN-1)] = Contours [0:(ContourN-1)]
  DotsToPlot [1,0:(ContourN-1)] = Contours [0:(ContourN-1)]
  DotsToPlot [0,ContourN] = Contours[ContourN-1] + $
  				(Contours[ContourN-1]-Contours[ContourN-2])
  DotsToPlot [1,ContourN] = Contours[ContourN-1] + $
  				(Contours[ContourN-1]-Contours[ContourN-2])
  
  DimTick = size(TickVals)
  TickN   = DimTick(1)
  
  if (keyword_set(Log)) then begin
    TickLo=TickVals(0) 		& TickLoLog=alog10(TickLo)
    TickHi=TickVals(TickN-1) 	& TickHiLog=alog10(TickHi)
    TickInterval=(TickHiLog-TickLoLog)/TickN
    for XTick=0,(TickN-1) do begin
      TickVals(XTick)=10.0^(TickLoLog+(XTick*TickInterval))
    endfor
  endif
  		
  TickText = strcompress(string(TickVals,format=TickFormat))
  
  if (keyword_set(Log)) then begin
    plot, [0,DotsToPlot[0,0]], xrange=[0,1],yrange=[DotsToPlot[0,0],DotsToPlot[0,ContourN]], $
  	ystyle=5, xstyle=5, position=BarCorners, /nodata, /noerase, /device, /ylog
  endif else begin
    plot, [0,DotsToPlot[0,0]], xrange=[0,1],yrange=[DotsToPlot[0,0],DotsToPlot[0,ContourN]], $
  	ystyle=5, xstyle=5, position=BarCorners, /nodata, /noerase, /device
  endelse
  
  contour, DotsToPlot,[0.0,1.0],reform(DotsToPlot[0,*]),levels=Contours, $
  	c_colors=ContourColors, /cell_fill,/overplot,$
	xrange=[0,1], yrange=[DotsToPlot[0,0],DotsToPlot[0,ContourN]], $
	ystyle=5,xstyle=5,position=BarCorners,/device
		
  if (keyword_set(Log)) then begin
    axis, yaxis=5, yticks=(TickN-1), ytickv=TickVals, ytickname=TickText, yminor=1, $
  	yticklen=-0.2, font=5, charsize=TextSize, charthick=TextThick, /ylog
  endif else begin
    axis, yaxis=5, yticks=(TickN-1), ytickv=TickVals, ytickname=TickText, yminor=1, $
  	yticklen=-0.2, font=5, charsize=TextSize, charthick=TextThick
  endelse
endif

end
