; fed with data in DataSlice     (real array)
; returns colours in ColourSeries (integer vector)
; MissColour (index 0...255) is integer
; ScaleLimits = real array size 4

function ColourSeries, DataVector, ScaleLimits, MissColour

MissVal = -999.0

Dims  = size(DataVector)
DataN = Dims(1)

RangeFract = 0.0D
ColSelect  = 0.0D

Squashed     = dblarr (DataN)
Squashed [*] = MissVal

ColourSeries     = intarr (DataN)
ColourSeries [*] = MissColour

for XDatum = 0, (DataN-1) do begin
    if (DataVector[XDatum] NE MissVal) then begin

      if            (DataVector[XDatum] GT ScaleLimits[1]) then begin
      	Squashed[XDatum] = ScaleLimits[1]
      endif else if (DataVector[XDatum] LT ScaleLimits[0]) then begin
      	Squashed[XDatum] = ScaleLimits[0]
      endif else begin
        Squashed[XDatum] = DataVector[XDatum]
      endelse
      
      RangeFract = (Squashed[XDatum] - ScaleLimits[0]) / (ScaleLimits[1] - ScaleLimits[0])
      
      ColSelect = (RangeFract * float(ScaleLimits[3]-ScaleLimits[2])) + float(ScaleLimits[2])
      
      ColourSeries[XDatum] = round (ColSelect)	    
    endif
endfor

return, ColourSeries

end
