; plotspatiallabel.pro
; plots .glo in the manner of plotspatial, but with the specs up front in the call
; MOD TO PLOT SPECIFIC LABELS
; IDL program written by Tim Mitchell on 17.05.01
; last modified on 05.07.02

pro PlotSpatialLabel, $
	GridIndex=GridIndex, $		; index of single grid (e.g. ATEAM=15 - see SelectModel)
	Filter=Filter, $		; default=""
	FileList=FileList, $		; if set, this overrides Filter and QBatchSingle
	MainTitle=MainTitle, $		; title in title bar (default='test')
	SavePath=SavePath, $		; .eps or .cgm filepath (default='test.eps')
	Variable=Variable, $		; -1=cld,1=dtr,2=pre,3=prr,4=prc,5=tmp,6=vap,
	$				; 7=elv,8=kay,9=koeppen,10=count,11=wet,12=frs,13=spc
	Statistic=Statistic, $		; 0=mean, 1=response, 2=anom(abs), 3=diff, 4=anom%
	QView=QView, $			; the view to plot, default=0(globe)
	QStanCust=QStanCust, $		; standard (default=0) or custom (=1) specifications
	PlotN=PlotN, $			; number of .glo to plot (default depends)
	ColN=ColN, RowN=RowN, $		; default=auto
	QSeasons=QSeasons, $		; -1=no,1=seasons,2=months (default depends on PlotN)
	QOneGrid=QOneGrid, $		; .glo files on one model grid (1=yes&default,2=no)
	QBatchSingle=QBatchSingle, $	; load files as batch (=1) or singly (=2), default depends
	PlotListName=PlotListName, $	; plot labels: if set, overrides QPlotName
	QPlotName=QPlotName, $		; label the plots (2=no,1=yes) default=2 if QSeasons>0
	QSameScale=QSameScale, $	; do the plots have the same scale (1=yes&default,2=no)
	QMapGrid=QMapGrid, $		; plot onto map (=2,default) or grid (=1)
	QContourCell=QContourCell, $	; plot contours (=2) or cells (=1,default)
	ContourFactor=ContourFactor, $	; contour density (1-5,default=5)
	QGrid=QGrid, $			; grid? 2=no(default),1=yes
	QOutline=QOutline, $		; -2=IDLcoasts(default),-1=no
	QBarInfo=QBarInfo, $		; extras (-1=none,1=all(default),2=attrib,3=info) scale=auto
	QStanFit=QStanFit, $		; plot shape (standard=2,fit-glo(=1,default))
	PlotSizeFac=PlotSizeFac, $ 	; default=1.0
	LabelSizeFac=LabelSizeFac, $	; default=1.0
	Choice=Choice			; 21=screen-plot, 22=eps-plot (default depends)

if not(keyword_set(Variable)) 		then Variable=0		
if not(keyword_set(Statistic)) 		then Statistic=0		

if not(keyword_set(QStanCust)) 		then QStanCust=0		
if not(keyword_set(MainTitle)) 		then MainTitle='test'		
if not(keyword_set(QOneGrid)) 		then QOneGrid=1
if not(keyword_set(QSameScale)) 	then QSameScale=1
if not(keyword_set(QView)) 		then QView=0
if not(keyword_set(QMapGrid)) 		then QMapGrid=0
if not(keyword_set(GridIndex)) 		then GridIndex=-999
if not(keyword_set(Filter)) 		then Filter=""
if not(keyword_set(QContourCell)) 	then QContourCell=1
if not(keyword_set(ContourFactor)) 	then ContourFactor=5
if not(keyword_set(QBarInfo))		then QBarInfo=1
if not(keyword_set(QStanFit))		then QStanFit=1
if not(keyword_set(PlotSizeFac))	then PlotSizeFac=1.0
if not(keyword_set(LabelSizeFac))	then LabelSizeFac=1.0
if not(keyword_set(SavePath))		then SavePath='test.eps'
if (keyword_set(FileList))		then Filter=""
if (keyword_set(FileList))		then QBatchSingle=2
if (keyword_set(PlotListName))		then QPlotName=1

if (keyword_set(FileList)) then begin
  DimFileList = size(FileList)
  PlotN = DimFileList[1]
endif else if (not(keyword_set(PlotN))) then begin
  PlotN = 1
  if (Filter ne "") then begin
    GetFileBatch, CheckFiles, CheckFileN, CallFilter=Filter
    if (CheckFileN gt 0) then PlotN=CheckFileN
  endif
endif

if ((not(keyword_set(ColN))) or (not(keyword_set(RowN)))) then begin
 if            (PlotN EQ 1) then begin
  ColN = 1 & RowN = 1
 endif else if (PlotN EQ 4) then begin
  ColN = 2 & RowN = 2
 endif else if (PlotN EQ 6) then begin
  ColN = 3 & RowN = 2
 endif else if (PlotN EQ 9) then begin
  ColN = 3 & RowN = 3
 endif else if (PlotN EQ 12) then begin
  ColN = 3 & RowN = 4
 endif else begin
  ColN = PlotN & RowN = 1
 endelse
endif

if (not(keyword_set(QSeasons))) then begin
  QSeasons=0
  if (PlotN EQ  4) then QSeasons=1
  if (PlotN EQ 12) then QSeasons=2
endif
if (QSeasons eq -1) then QSeasons=0

if (QSeasons gt 0) then begin
  if (not(keyword_set(QPlotName))) then QPlotName=1
endif else begin
  if (not(keyword_set(QPlotName))) then QPlotName=0
endelse

if (not(keyword_set(QBatchSingle))) then begin
  QBatchSingle = 2
  if (QSeasons NE 1 AND PlotN GT 1 AND QOneGrid EQ 1) then QBatchSingle = 1
  if (keyword_set(Filter)) then QBatchSingle = 1
endif

if (not(keyword_set(QGrid))) then begin
  QGrid = -999
  if (QMapGrid EQ 0) then QGrid=0
endif

if (not(keyword_set(QOutline))) then begin
  QOutline = -999
  if (QMapGrid EQ 0) then QOutline=-2
endif

if (not(keyword_set(Choice))) then begin
  if (keyword_set(SavePath)) then begin
    Choice = 22
  endif else begin
    Choice = 21
  endelse
endif

if (QMapGrid eq 2) then QMapGrid=0
if (QContourCell eq 2) then QContourCell=0
if (QGrid eq 2) then QGrid=0
if (QOutline eq -1) then QOutline=0
if (QStanFit eq 2) then QStanFit=0
if (QPlotName eq 2) then QPlotName=0
if (QBarInfo eq -1) then QBarInfo=0
if (Variable eq -1) then Variable=0

; ******************************************************************************
; initialisations
  
print, "  > Plotting ", strtrim(MainTitle)
givesymbol,MainTitle

Black = 0 & Grey = 254 & White = 255
MissVal  = -999.0 & MissCol = White
ScaleSegN = 10 & ModelChosen = -999 & BatchFileN = 0
InputText = """

MonthNames = strarr (12)
MonthNames [*] = ['January','February','March','April','May','June','July','August', $
		  'September','October','November','December']
SeasonNames = strarr (4)
SeasonNames = ['winter (DJF)','spring (MAM)','summer (JJA)','autumn (SON)']
ColorBounds  = [1,253]

VariStr = ['cloud cover','DTR','precipitation','precipitation','precipitation', $
	   'temperature','vapour pressure','elevation','constant','koeppen','count', $
	   'wet days','frost days','sunshine']
UnitStr = ['percentage','degC','mm','mm/day','percentage','degC','hPa','m','','class', $
	   'number','days','days','percentage']
StatStr = ['mean','response','anomaly','difference','anomalyPC']

; ******************************************************************************
; get model stuff

Models = intarr (PlotN) & ModelsLongN = intarr (PlotN) & ModelsLatN = intarr (PlotN)

if (PlotN EQ 1) then begin
  SelectModel, GridIndex, ModelFilePath, LongN, LatN, /Extend
  Models(0)=GridIndex & ModelsLongN(0)=LongN & ModelsLatN(0)=LatN
  QOneGrid = 1
endif else begin
  if (QOneGrid EQ 1) then begin
    SelectModel, GridIndex, ModelFilePath, LongN, LatN, /Extend
    Models(*)=GridIndex & ModelsLongN(*)=LongN & ModelsLatN(*)=LatN
  endif
endelse

GetViewBounds, ViewN, ViewName, ViewKeyWords, ViewBounds, ViewFullName=ViewFullName
GetScales, ScaleN, ScaleName, ScaleColTab, ScaleSeg, ScaleLimits 

FilePaths = strarr (PlotN)
FileInfos = strarr (PlotN)

if (QBatchSingle EQ 1) then begin
 while (BatchFileN NE PlotN) do begin
   GetFileBatch, Files, BatchFileN, CallFilter=Filter
   if (BatchFileN NE PlotN) then begin
   	print, "   > Enter new filter. The filter gives a file total of: ", BatchFileN
   	Filter=""
   endif
 endwhile
 
 for XPlot = 0, (PlotN-1) do begin
  CheckGlo, GridIndex, FilePath, FileInfo, /NoPrompt, CallFile=Files(XPlot)
  FilePaths(XPlot) = FilePath
  FileInfos(XPlot) = FileInfo
 endfor
endif else if (keyword_set(FileList)) then begin
 for XPlot = 0, (PlotN-1) do begin
  GivenFile = FileList(XPlot)	; auto read from FileList
  CheckGlo, GridIndex, FilePath, FileInfo, CallFile=GivenFile
  FilePaths(XPlot) = FilePath
  FileInfos(XPlot) = FileInfo
 endfor
 
endif else begin
 for XPlot = 0, (PlotN-1) do begin
  if            (QSeasons EQ 1) then begin
    print, "  > Enter .glo for season: ", SeasonNames [XPlot]
  endif else if (QSeasons EQ 2) then begin
    print, "  > Enter .glo for month: ", MonthNames [XPlot]
  endif else if (PlotN EQ 1) then begin
    print, "  > Enter the .glo file."
  endif else if (QOneGrid NE 1) then begin
    print, "  > Plot: ", XPlot
    SelectModel, GridIndex, ModelFilePath, LongN, LatN, /Extend
    Models(XPlot)=GridIndex & ModelsLongN(XPlot)=LongN & ModelsLatN(XPlot)=LatN
    print, "  > Enter the .glo file: ", XPlot
  endif else if (XPlot EQ 0) then begin
    print, "  > Enter each .glo file in turn."
  endif

  CheckGlo, GridIndex, FilePath, FileInfo, /NoPrompt
  FilePaths(XPlot) = FilePath
  FileInfos(XPlot) = FileInfo
 endfor
endelse

; ******************************************************************************
; plot choices

if (keyword_set(PlotListName)) then begin
   PlotName = strarr (PlotN)
   for XPlot = 0, (PlotN-1) do begin
      PlotName[XPlot] = PlotListName[XPlot]
      GiveSymbol, PlotName[XPlot]
   endfor
endif else if (QPlotName EQ 1 AND QSeasons EQ 0) then begin
   PlotName = strarr (PlotN)
   print, "  > Enter the title for each plot in turn: "
   for XPlot = 0, (PlotN-1) do begin
      read, InputText
      PlotName[XPlot] = InputText
      GiveSymbol, PlotName[XPlot]
   endfor
endif

if (QSameScale EQ 1) then begin
  Info = strarr (10) & Info [*] = "missing"
  Info[0] = VariStr[Variable]
  Info[3] = UnitStr[Variable]
  Info[1] = StatStr[Statistic]
  if (strtrim(Info[1]) eq 'anomalyPC') then Info[3] = 'percentage'
  
  SeasName = "annual" & SeasIndex=17
endif

if (QView LT 0 OR QView GE ViewN) then QView = 0
Limits = [ViewBounds[QView,2],ViewBounds[QView,0],ViewBounds[QView,3],ViewBounds[QView,1]]
       
QBottomRight = QBarInfo
if (QBarInfo eq 1) then QBottomRight = 3
if (QBarInfo eq 2) then QBottomRight = 0

if (QStanFit EQ 1 AND QOneGrid EQ 2) then begin
  print, "  > Plot shape: enter LongN,LatN: "
  read, LongN,LatN
endif

TextSize = 0.8 & TextThick = 2.0

; ******************************************************************************
; determine plot size and identify plot segments
; note that when multiple grids are used in a single execution, this will go wonky

if (MainTitle ne 'test' or qbarinfo eq 1 or qbarinfo eq 2) then begin
  TitlePixels = 2.5
endif else begin
  TitlePixels = 0.0
endelse

if (QBarInfo EQ 0) then begin 				; this allows width for just the scale
;  BarPixels = 3.0
  BarPixels = 4.0
endif else begin					; this allows width for the logo and info as well
  BarPixels = 4.0
endelse

if (QPlotName EQ 0) then begin 				; this allows height for the label, if required
  NamePixels = 0.0
endif else begin					
  NamePixels = 1.0
endelse

if (QStanFit EQ 0) then begin				; this makes any PS plot have a size 16cm * 12cm
							;   so fits into Word doc without any resizing
  XPixels = 16.0 & YPixels = 12.0  	
endif else begin					; this sizes the plot according to the .glo sizes
					  		;   so minimises white space in the plot
  YPixels = (float(RowN)*PlotSizeFac*float(LatN)/20.0) + (float(RowN)*LabelSizeFac*NamePixels) $
  		+ (TitlePixels*LabelSizeFac)
  
  if (QSameScale EQ 2) then begin
    XPixels =  float(ColN) * ( (float(LongN)*PlotSizeFac/20.0) + BarPixels )
  endif else begin
    XPixels = (float(ColN) * float(LongN) * PlotSizeFac / 20.0)  + BarPixels
  endelse
endelse

BarWidth   = BarPixels / XPixels			; this converts the key width into normalised units
NameHeight = LabelSizeFac * NamePixels / YPixels	; ... and the name height likewise
TopBarHeight= TitlePixels / XPixels			; ... and the title bar

							; this identifies the normalised key boundaries
if (QSameScale EQ 2) then begin				; here, one scale per .glo
  GetCorners, [0.0,0.0,1.0,(1.0-TopBarHeight)], PlotCorners, ColN, RowN, 0
  ScaleCorners = PlotCorners
  PlotCorners  [*,2] = PlotCorners  [*,2] - BarWidth
  ScaleCorners [*,0] = ScaleCorners [*,2] - BarWidth
endif else begin					; here one scale for the entire plot
  GetCorners, [0.0,0.0,(1.0-BarWidth),(1.0-TopBarHeight)], PlotCorners,  ColN, RowN, 0
  GetCorners, [(1.0-BarWidth),0.0,1.0,(1.0-TopBarHeight)], ScaleCorners, 1,	  1, 0
endelse

if (QPlotName EQ 1) then begin				; this provides space for a label for each .glo
  LabelCorners = PlotCorners
  
  PlotCorners  [*,3] = PlotCorners  [*,3] - NameHeight
  LabelCorners [*,1] = LabelCorners [*,3] - NameHeight

  if (QSameScale EQ 2) then ScaleCorners [*,3] = ScaleCorners [*,3] - NameHeight
endif else begin
  LabelCorners = PlotCorners * 0.0
endelse

for XPlot = 0, (PlotN-1) do begin			; this ensures each .glo has correct width/length
  XGloPixels = (PlotCorners[XPlot,2] - PlotCorners[XPlot,0]) * XPixels
  YGloPixels = (PlotCorners[XPlot,3] - PlotCorners[XPlot,1]) * YPixels
  
  if (YGloPixels/XGloPixels LT float(LatN)/float(LongN)) then begin
    XNewPixels = YGloPixels * (float(LongN)/float(LatN))
    PlotCorners[XPlot,0] = PlotCorners[XPlot,0] + ((XGloPixels-XNewPixels)/(2.0*XPixels))
    PlotCorners[XPlot,2] = PlotCorners[XPlot,2] - ((XGloPixels-XNewPixels)/(2.0*XPixels))
  endif else begin
    YNewPixels = XGloPixels * (float(LatN)/float(LongN))
    PlotCorners[XPlot,1] = PlotCorners[XPlot,1] + ((YGloPixels-YNewPixels)/(2.0*YPixels))
    PlotCorners[XPlot,3] = PlotCorners[XPlot,3] - ((YGloPixels-YNewPixels)/(2.0*YPixels))
  endelse
endfor

TopBarSpec = fltarr(3,4) & TopBarSpec(*,*)=-1.0			; gets title bar positions
TopBarIndent = TopBarHeight/5.0

if (QBarInfo eq 1 or QBarInfo eq 2) then begin				; logo x:y = 834:184
	TopBarSpec(0,1) = (1.0-(TopBarHeight-TopBarIndent))
	TopBarSpec(0,3) = (TopBarHeight-(TopBarIndent*2.0))

	TopBarSpec(0,0) = TopBarIndent
	TopBarSpec(0,2) = TopBarSpec(0,3)*834.0/184.0
endif

TopBarSpec(1,*) = [0.5,(1.0-(TopBarHeight/1.4)),-1,-1]

if (QBarInfo eq 1 or QBarInfo eq 2) then begin
	TopBarSpec(2,0) = 1.0-TopBarIndent
	TopBarSpec(2,1) = 1.0-(TopBarIndent*2.5)
	TopBarSpec(2,2) = 1.0-TopBarIndent
	TopBarSpec(2,3) = 1.0-(TopBarHeight-TopBarIndent)
endif

; ******************************************************************************
; plot each .glo

SeasName = "" & SeasClash = 0

if (Choice EQ 21) then begin
 set_plot, 'X'	
 if (!D.Window EQ -1) then window, /free, xsize=(XPixels*32.0), ysize=(YPixels*32.0), $
  		xpos=(1000-(XPixels*32.0)), title="box plot"
endif else begin
 EPSbeg = strpos(SavePath,".eps")
 CGMbeg = strpos(SavePath,".cgm")
 
 if (EPSbeg ne -1) then begin
  Set_Plot, 'ps', /copy
  device, filename=SavePath, bits_per_pixel=8, xsize=XPixels, ysize=YPixels,/Color,/encapsulated
 endif else if (CGMbeg ne -1) then begin
  Set_Plot, 'cgm', /copy
  device, filename=SavePath
 endif
endelse

for XPlot = 0, (PlotN-1) do begin
; ##### do standard or custom formatting #####

  if (QStanCust EQ 0) then begin
    if (QSeasons EQ 0 OR XPlot EQ 0) then begin
      if (QSameScale EQ 2) then begin
        Info = strarr (10) & Info [*] = "missing"
        if (QSeasons GT 0) then Info[5] = "various"

        GrabInfo, FilePaths(XPlot), FileInfos(XPlot), Info, QView, QBarInfo
        
        if (Info[5] EQ "missing") then begin
          SeasName = "missing"
          SearchSeas, FilePaths(XPlot), FileInfos(XPlot), SeasName, SeasIndex=SeasIndex
        endif else begin
          SeasName = "missing"
          SearchSeas, FilePaths(XPlot), Info[5], SeasName, SeasIndex=SeasIndex
        endelse
      endif
      
      LoadVariCT, Info, ContourFactor, DataBounds, ContourN, TickVals, TickFormat, SeasIndex=SeasIndex  
    endif
  endif else begin
    Info = strarr (10) & Info [*] = "missing"
  
    LoadVariCT, Info, ContourFactor, DataBounds, ContourN, TickVals, TickFormat, SeasIndex=SeasIndex 
  endelse
  
; ##### prepare plot #####
  
  GetContours, DataBounds, ColorBounds, Contours, ContourColors, ContourN
  
  ExeRef = ((LabelCorners[XPlot,2] - LabelCorners[XPlot,0]) / 2.0) + LabelCorners[XPlot,0]
  WyeRef = ((LabelCorners[XPlot,3] - LabelCorners[XPlot,1]) / 3.0) + LabelCorners[XPlot,1]
  
  LoadGlo, Models(XPlot), GloSlice, FilePaths(XPlot), FileInfo, /Silent
  if (QPlotName EQ 1) then begin
    if (QSeasons EQ 0) then xyouts, ExeRef,WyeRef,PlotName[XPlot],font=5,charsize=(1.2*LabelSizeFac), $
    					charthick=2.0,/normal,alignment=0.5
    if (QSeasons EQ 1) then xyouts, ExeRef,WyeRef,SeasonNames(XPlot),font=5,charsize=(1.2*LabelSizeFac), $
    					charthick=2.0,/normal,alignment=0.5
    if (QSeasons EQ 2) then xyouts, ExeRef,WyeRef,MonthNames(XPlot),font=5,charsize=(1.2*LabelSizeFac), $
    					charthick=2.0,/normal,alignment=0.5
  endif
  
  TrimSlice = GloSlice
;  makegrey  = where (GloSlice EQ 1, count) & TrimSlice(makegrey )=254
;  makegrey  = where (GloSlice EQ 4, count) & TrimSlice(makegrey )=254
;  makegrey  = where (GloSlice EQ 8, count) & TrimSlice(makegrey )=254
;  makewhite = where (GloSlice EQ 2, count) & TrimSlice(makewhite)=255
;  makewhite = where (GloSlice EQ 5, count) & TrimSlice(makewhite)=255
;  makewhite = where (GloSlice EQ 7, count) & TrimSlice(makewhite)=255
;  makeblack = where (GloSlice EQ 3, count) & TrimSlice(makeblack)=0
;  makeblack = where (GloSlice EQ 6, count) & TrimSlice(makeblack)=0
;  makeblack = where (GloSlice EQ 9, count) & TrimSlice(makeblack)=0
  
  
  makemiss  = where (GloSlice EQ -999, count)
  makegrey  = where (GloSlice EQ 0 OR GloSlice EQ 3 OR GloSlice EQ 7, count)
  makewhite = where (GloSlice EQ 1 OR GloSlice EQ 4 OR GloSlice EQ 6, count)
  makeblack = where (GloSlice EQ 2 OR GloSlice EQ 5 OR GloSlice EQ 8, count)
  TrimSlice(makemiss )=255	; !Values.F_NaN
  TrimSlice(makegrey )=254
  TrimSlice(makewhite)=255
  TrimSlice(makeblack)=0
  
; ##### do plot #####
  
  if (QMapGrid EQ 0) then begin
    if (ViewKeyWords[QView,0] EQ 'Lamb') then Map_set, 0, 0, /lambert, color=Black, /noerase, $
  	position=PlotCorners[XPlot,*], /noborder, limit=Limits 
    if (ViewKeyWords[QView,0] EQ 'Cyli') then Map_set, 0, 0, /cylindrical, color=Black, /noerase, $
  	position=PlotCorners[XPlot,*], /noborder, limit=Limits
    if (ViewKeyWords[QView,0] EQ 'Hamm') then Map_set, 0, 0, /hammer, color=Black, /noerase, $
  	position=PlotCorners[XPlot,*], /noborder, limit=Limits
  endif
  
  GetContourVec, Models(XPlot), Lons, Lats
  
  if (QContourCell EQ 0) then begin
   if (QMapGrid EQ 0) then begin
    contour, TrimSlice, Lons, Lats, levels=Contours, c_colors=ContourColors, /cell_fill, $
  	/overplot,/noerase
   endif else begin
    contour, TrimSlice, xrange=[Limits(1),Limits(3)], xstyle=5, ystyle=5, xticks=1, yticks=1, $
    	yrange=[Limits(0),Limits(2)], color=Black, $
    	/noerase, position=PlotCorners[XPlot,*], /nodata
    contour, TrimSlice, Lons, Lats, levels=Contours, c_colors=ContourColors, /cell_fill, $
  	/overplot,/noerase
   endelse
  endif else begin
   if (QMapGrid EQ 0) then begin
     Map = map_image (TrimSlice, startx, starty, xs, ys, $
	lonmin=Lons[0], lonmax=Lons[ModelsLongN(XPlot)-1], latmin=Lats[0], latmax=Lats[ModelsLatN(XPlot)-1], $
	compress=1, min_value=(MissVal+1), missing=white)
	
     TV, Map, startx, starty, xsize=xs, ysize=ys
   endif else begin
     TV,TrimSlice,PlotCorners[XPlot,0],PlotCorners[XPlot,1],/normal, $
      	xsize=(PlotCorners[XPlot,2]-PlotCorners[XPlot,0]),ysize=(PlotCorners[XPlot,3]-PlotCorners[XPlot,1])
   endelse
  endelse
  
  if (QOutline NE 0 AND QMapGrid EQ 0) then begin
    if (ViewKeyWords[QView,0] EQ 'Lamb') then Map_set, 0, 0, /lambert, color=Black, /noerase, $
  	position=PlotCorners[XPlot,*], /continents, /noborder, limit=Limits 
    if (ViewKeyWords[QView,0] EQ 'Cyli') then Map_set, 0, 0, /cylindrical, color=Black, /noerase, $
  	position=PlotCorners[XPlot,*], /continents, /noborder, limit=Limits
    if (ViewKeyWords[QView,0] EQ 'Hamm') then Map_set, 0, 0, /hammer, color=Black, /noerase, $
   	position=PlotCorners[XPlot,*], /continents, /noborder, limit=Limits
  endif
  
  if (QGrid EQ 1 AND QMapGrid EQ 0) then begin
    if (ViewKeyWords[QView,0] EQ 'Lamb') then Map_set, 0, 0, /lambert, color=Black, /noerase, $
  	position=PlotCorners[XPlot,*], /grid, glinestyle=0, /noborder, limit=Limits 
    if (ViewKeyWords[QView,0] EQ 'Cyli') then Map_set, 0, 0, /cylindrical, color=Black, /noerase, $
  	position=PlotCorners[XPlot,*], /grid, glinestyle=0, /noborder, limit=Limits
    if (ViewKeyWords[QView,0] EQ 'Hamm') then Map_set, 0, 0, /hammer, color=Black, /noerase, $
   	position=PlotCorners[XPlot,*], /grid, glinestyle=0, /noborder, limit=Limits
  endif
  
  xyouts,90.0,30.0,'Asia',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,70.0,55.0,'ex-USSR',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,25.0,5.0,'Africa',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,70.0,-10.0,'Middle',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,70.0,-18.0,'East',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,160.0,-30.0,'Oceania',alignment=0,charsize=2,charthick=1,font=5
  xyouts,-25.0,45.0,'Europe',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,-55.0,35.0,'North',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,-55.0,27.0,'America',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,-125.0,20.0,'Central',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,-115.0,12.0,'America',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,-60.0,-08.0,'South',alignment=0.5,charsize=2,charthick=1,font=5
  xyouts,-60.0,-16.0,'America',alignment=0.5,charsize=2,charthick=1,font=5
  
  arrow, 61.0,-2.0, 57.5,17.5, color=0, /data,/solid,thick=2,hthick=2
endfor

if (QBarInfo eq 1 or QBarInfo eq 2) then begin
 if (Choice EQ 22) then begin
  read_jpeg, '/cru/tyn1/f709762/goglo/tyn-logo-torok.jpg', Logo, LogoCT, colors=256, dither=1, /two_pass_quantize
  tvlct, Red,Green,Blue, /get						; get old colors
  tvlct, LogoCT(*,0), LogoCT(*,1), LogoCT(*,2)
  tv, Logo, TopBarSpec[0,0],TopBarSpec[0,1],xsize=TopBarSpec[0,2],ysize=TopBarSpec[0,3],/normal
  tvlct, Red,Green,Blue							; restore old colors
 endif else begin
  xyouts,TopBarSpec[0,0],TopBarSpec[0,1],'logo',/normal,alignment=0,charsize=(1.0*LabelSizeFac),charthick=1,font=5
 endelse
 
 Author = 'Tim Mitchell'
 DateTime  = systime ()
 DateStamp = strmid(DateTime,4,7) + strmid(DateTime,20,4)
 xyouts,TopBarSpec[2,0],TopBarSpec[2,1],Author,/normal,alignment=1,charsize=(1.0*LabelSizeFac),charthick=1,font=5
 xyouts,TopBarSpec[2,2],TopBarSpec[2,3],DateStamp,/normal,alignment=1,charsize=(1.0*LabelSizeFac),charthick=1,font=5
endif

if (MainTitle ne 'test') then $
  xyouts,TopBarSpec[1,0],TopBarSpec[1,1],MainTitle,/normal,alignment=0.5,charsize=2.5,charthick=3,font=5

; ******************************************************************************
; finish

if (Choice EQ 22) then device, /close

set_plot, 'X'	

end 
