; getnetcdf.pro
; written by Tim Mitchell on 29.02.00
; last modified on 29.02.00
; program to extract from .nc to .mon

SourcePath = '/cru/u2/f055/data/mod/hadcm2/con1000/nc/HCCI_temk_'
SavePath   = '/cru/mikeh1/f709762/temk/hadcm2/con/HCCI_temk_'
SourceFile = 'blank'
SaveFile   = 'blank'

for XSource = 0, 28 do begin
  ADYear0 = 2100 + (XSource * 40)		; construct .nc filename
  ADYear1 = ADYear0 + 39

  TextADYear0 = string (ADYear0)
  TextADYear1 = string (ADYear1)
  
  SourceFile = SourcePath + strtrim(TextADYear0,2) + '-' + strtrim(TextADYear1,2) + '.mon.nc'
  
  print, "  > Extracting from .nc file with start year: ", ADYear0 
  
  NCID = ncdf_open (SourceFile)			; extract data
  ncdf_varget, NCID, 'temperature', AllData
  ncdf_close, NCID				; AllData (long,lat,year&month)
  
  for XDecade = 0, 3 do begin					; save decades to .mon
    ADYear0 = 2100 + (XSource * 40) + (XDecade * 10)		; construct .mon filename
    ADYear1 = ADYear0 + 9

    TextADYear0 = string (ADYear0)
    TextADYear1 = string (ADYear1)
  
    print, "  > Saving to .mon file with start year: ", ADYear0 
  
    SaveFile = SavePath + strtrim(TextADYear0,2) + '-' + strtrim(TextADYear1,2) + '.mon'  
    openw, lunDat, SaveFile, /get_lun
  
    for XYear = (XDecade*10), ((XDecade*10)+9) do begin		; save each year, month, lat
     for XMonth = 0, 11 do begin
      for XLat = 0, 72 do begin
       
       SaveLine = reform (AllData (*,XLat,(XYear*12+XMonth)))
       printf, lunDat, SaveLine, format="(96(e16.7))"
      
      endfor
     endfor
    endfor
  
    free_lun, lunDat
  endfor
  
  AllData = 0.0
endfor

end
