<?xml version="1.0" encoding="utf-8"?>

<!-- **************************************************************** -->
<!--                            UNCLASSIFIED                          -->
<!-- **************************************************************** -->

<!-- **************************************************************** -->
<!--             IC Information Security Marking Standard             -->
<!--         Classificatiion/Declassification Block Stylesheet        -->
<!--                                                                  -->
<!-- File:     IC-ISM-ClassDeclass-v2.0.xsl                           -->
<!-- Schema:   Corresponds to IC ISM v2.0                             -->
<!-- Version:  2.0                                                    -->
<!-- Date:     2004-04-30                                             -->
<!-- Creators: Science Applications International Corporation         -->
<!--           (for the IC Metadata Working Group)                    -->
<!-- **************************************************************** -->

<!-- **************************************************************** -->
<!--                            INTRODUCTION                          -->
<!--                                                                  -->
<!-- Intelligence Community Information Security Marking (IC ISM)     -->
<!-- standard was developed by the IC Security Panel for the express  -->
<!-- purpose of promoting CAPCO security marking interoperability     -->
<!-- between members of the Intelligence Community.                   -->
<!-- **************************************************************** -->
     
<!-- **************************************************************** -->
<!--                            DESCRIPTION                           -->
<!--                                                                  -->
<!-- This stylesheet renders classification/declassification blocks   -->
<!-- containing the "Classified By", "Reason", "Derived From", and/or -->
<!-- "Declassify On" information required by the CAPCO Implementation -->
<!-- Manual pursuant to ISOO Directive 1 and Executive Order 12958.   -->
<!-- **************************************************************** -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!-- **************************************************************** -->
<!-- class.declass - renders the classification/declassification      -->
<!-- block.                                                           -->
<!-- **************************************************************** -->

<xsl:template name="class.declass">
  <xsl:param name="classification"/>
  <xsl:param name="classifiedby"/>
  <xsl:param name="classificationreason"/>
  <xsl:param name="derivedfrom"/>
  <xsl:param name="declassdate"/>
  <xsl:param name="declassexception"/>
  <xsl:param name="declassevent"/>
  <xsl:param name="typeofexemptedsource"/>
  <xsl:param name="dateofexemptedsource"/>

  <xsl:variable name="n-classification" select="normalize-space($classification)"/>
  <xsl:variable name="n-classifiedby" select="normalize-space($classifiedby)"/>
  <xsl:variable name="n-classificationreason" select="normalize-space($classificationreason)"/>
  <xsl:variable name="n-derivedfrom" select="normalize-space($derivedfrom)"/>
  <xsl:variable name="n-declassdate" select="normalize-space($declassdate)"/>
  <xsl:variable name="n-declassexception" select="normalize-space($declassexception)"/>
  <xsl:variable name="n-declassevent" select="normalize-space($declassevent)"/>
  <xsl:variable name="n-typeofexemptedsource" select="normalize-space($typeofexemptedsource)"/>
  <xsl:variable name="n-dateofexemptedsource" select="normalize-space($dateofexemptedsource)"/>

  <!-- **************************************************************** -->
  <!-- Display the "Classified By" line or the "Derived From" line.     -->
  <!--                                                                  -->
  <!-- NOTE: A classified document can be either an originally          -->
  <!--       classified document or a derivatively classified document. -->
  <!--       An originally classified document will contain a           -->
  <!--       "Classified By" line, and a derivatively classified        -->
  <!--       document will contain a "Derived From" line.               -->
  <!--                                                                  -->
  <!-- Display the "Reason" line.                                       -->
  <!--                                                                  -->
  <!-- NOTE: For originally classified documents, the reason for the    -->
  <!--       classification decision should always be specified.        -->
  <!--                                                                  -->
  <!--       According to ISOO Directive 1, Section 2001.22(c), for     -->
  <!--       derivatively classified documents, the reason for the      -->
  <!--       original classification decision, as reflected in the      -->
  <!--       source document(s) or classification guide, is not         -->
  <!--       required.  If included, however, it shall conform to the   -->
  <!--       standards in Section 2001.21(a)(3).                        -->
  <!--                                                                  -->
  <!--       In other words, the "Reason" line can be included in the   -->
  <!--       classification/declassification block for derivatively     -->
  <!--       classified documents.                                      -->
  <!-- **************************************************************** -->

  <xsl:if test="(($n-classification != '') and ($n-classification != 'U') and ($n-classification != 'NU')) or
                (($n-classifiedby != '') or ($n-classificationreason != '') or ($n-derivedfrom != '') or
                ($n-declassdate != '') or ($n-declassexception != '') or ($n-declassevent != '') or 
                ($n-typeofexemptedsource != '') or ($n-dateofexemptedsource != ''))">
    <p style="margin-top: 30">
    <xsl:variable name="warning1">
      <xsl:if test="$n-classification = ''">
        <xsl:text>( WARNING! This document does not contain a required overall classification marking. )</xsl:text>
      </xsl:if>
    </xsl:variable>
    <xsl:if test="$warning1 != ''">
      <b><font color="red"><xsl:value-of select="$warning1"/></font></b>
    </xsl:if>
    <xsl:variable name="warning2">
      <xsl:if test="($n-classification = 'U') or ($n-classification = 'NU')">
        <xsl:text>( WARNING! This document contains overall markings for both an unclassified and a classified document. )</xsl:text>
      </xsl:if>
    </xsl:variable>
    <xsl:if test="$warning2 != ''">
      <xsl:if test="$warning1 != ''">
        <br/>
      </xsl:if>
      <b><font color="red"><xsl:value-of select="$warning2"/></font></b>
    </xsl:if>
    <xsl:variable name="warning3">
      <xsl:if test="($n-classification != '') and ($n-classification != 'U') and ($n-classification != 'NU') and ($n-classifiedby = '') and ($n-derivedfrom = '')">
        <xsl:text>( WARNING! This document does not contain required markings for either an originally or derivatively classified document. )</xsl:text>
      </xsl:if>
    </xsl:variable>
    <xsl:if test="$warning3 != ''">
      <xsl:if test="($warning1 != '') or ($warning2 != '')">
        <br/>
      </xsl:if>
      <b><font color="red"><xsl:value-of select="$warning3"/></font></b>
    </xsl:if>
    <xsl:if test="$n-classifiedby != ''">
      <xsl:if test="($warning1 != '') or ($warning2 != '') or ($warning3 != '')">
        <br/>
      </xsl:if>
      <xsl:text>Classified By: </xsl:text>
      <xsl:value-of select="$n-classifiedby"/>
    </xsl:if>
    <xsl:if test="$n-derivedfrom != ''">
      <xsl:if test="($warning1 != '') or ($warning2 != '') or ($warning3 != '') or ($n-classifiedby != '')">
        <br/>
      </xsl:if>
      <xsl:text>Derived From: </xsl:text>
      <xsl:value-of select="$n-derivedfrom"/>
    </xsl:if>
    <xsl:if test="$n-classificationreason != ''">
      <xsl:if test="($warning1 != '') or ($warning2 != '') or ($warning3 != '') or ($n-classifiedby != '') or ($n-derivedfrom != '')">
        <br/>
      </xsl:if>
      <xsl:text>Reason: </xsl:text>
      <xsl:value-of select="$n-classificationreason"/>
    </xsl:if>
    <xsl:variable name="warning4">
      <xsl:if test="($n-classification != 'U') and ($n-classification != 'NU') and ($n-classifiedby != '') and ($n-derivedfrom != '')">
        <xsl:text>( WARNING! This document contains markings for both an originally and derivatively classified document. )</xsl:text>
      </xsl:if>
    </xsl:variable>
    <xsl:if test="$warning4 != ''">
      <xsl:if test="($warning1 != '') or ($warning2 != '') or ($warning3 != '') or ($n-classifiedby != '') or ($n-classificationreason != '') or ($n-derivedfrom != '')">
        <br/>
      </xsl:if>
      <b><font color="red"><xsl:value-of select="$warning4"/></font></b>
    </xsl:if>
    <xsl:variable name="warning5">
      <xsl:if test="($n-classification != '') and ($n-classification != 'U') and ($n-classification != 'NU') and ($n-classifiedby != '') and ($n-classificationreason = '')">
        <xsl:text>( WARNING! The reason for the classification decision should be specified for an originally classified document. )</xsl:text>
      </xsl:if>
    </xsl:variable>
    <xsl:if test="$warning5 != ''">
      <xsl:if test="($warning1 != '') or ($warning2 != '') or ($warning3 != '') or ($warning4 != '') or ($n-classifiedby != '') or ($n-classificationreason != '') or ($n-derivedfrom != '')">
        <br/>
      </xsl:if>
      <b><font color="red"><xsl:value-of select="$warning5"/></font></b>
    </xsl:if>

    <!-- **************************************************************** -->
    <!-- Display the "Declassify On" line.                                -->
    <!-- **************************************************************** -->

    <xsl:if test="($n-classifiedby != '') or ($n-classificationreason != '') or ($n-derivedfrom != '') or
                  ($warning1 != '') or ($warning2 != '') or ($warning3 != '') or ($warning4 != '') or ($warning5 != '')">
      <br/>
    </xsl:if>
    <xsl:variable name="warning6">
      <xsl:if test="($n-classification != '') and ($n-classification != 'U') and ($n-classification != 'NU') and
                    ($n-declassdate = '') and ($n-declassexception = '') and ($n-declassevent = '') and ($n-typeofexemptedsource = '')">
        <xsl:text>( WARNING! This document does not contain required declassification instructions or markings. )</xsl:text>
      </xsl:if>
    </xsl:variable>
    <xsl:if test="$warning6 != ''">
      <b><font color="red"><xsl:value-of select="$warning6"/></font></b>
    </xsl:if>
    <xsl:if test="($n-declassdate != '') or
                  ($n-declassexception != '') or
                  ($n-declassevent != '') or
                  ($n-typeofexemptedsource != '') or
                  ($n-dateofexemptedsource != '')">
      <xsl:if test="$warning6 != ''">
        <br/>
      </xsl:if>
      <xsl:text>Declassify On: </xsl:text>
    </xsl:if>
    <xsl:if test="$n-declassexception != ''">
      <xsl:value-of select="translate($n-declassexception,' ',',')"/>
    </xsl:if>
    <xsl:if test="$n-declassdate != ''">
      <xsl:if test="$n-declassexception != ''">
        <xsl:text>, </xsl:text>
      </xsl:if>
      <xsl:value-of select="translate($n-declassdate,'-','')"/>
    </xsl:if>
    <xsl:if test="$n-declassevent != ''">
      <xsl:if test="($n-declassexception != '') and ($n-declassdate = '')">
        <xsl:text>, </xsl:text>
      </xsl:if>
      <xsl:if test="$n-declassdate != ''">
        <xsl:text> or </xsl:text>
      </xsl:if>
      <xsl:value-of select="$n-declassevent"/>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="($n-typeofexemptedsource = '') and
                      ($n-dateofexemptedsource  != '')">
        <xsl:if test="($n-declassdate != '') or
                        ($n-declassexception != '') or
                        ($n-declassevent != '')">
          <xsl:text>, </xsl:text>
        </xsl:if>
        <xsl:text>Date of Source: </xsl:text>
        <xsl:value-of select="translate($n-dateofexemptedsource,'-','')"/>
        <br/>
        <b><font color="red"><xsl:text>( WARNING! The exempted source marking should be included when the date of exempted source is specified. )</xsl:text></font></b>
      </xsl:when>
      <xsl:when test="($n-typeofexemptedsource != '') and
                      ($n-dateofexemptedsource = '')">
        <xsl:if test="($n-declassdate != '') or
                        ($n-declassexception != '') or
                        ($n-declassevent != '')">
          <xsl:text>, </xsl:text>
        </xsl:if>
        <xsl:text>Source Marked </xsl:text>
        <xsl:value-of select="translate($n-typeofexemptedsource,' ',',')"/>
        <br/>
        <b><font color="red"><xsl:text>( WARNING! The date of exempted source marking should be included when the exempted source marking is specified. )</xsl:text></font></b>
      </xsl:when>
      <xsl:when test="($n-typeofexemptedsource != '') and
                      ($n-dateofexemptedsource != '')">
        <xsl:if test="($n-declassdate != '') or
                        ($n-declassexception != '') or
                        ($n-declassevent != '')">
          <xsl:text>, </xsl:text>
        </xsl:if>
        <xsl:text>Source Marked </xsl:text>
        <xsl:value-of select="translate($n-typeofexemptedsource,' ',',')"/>
        <xsl:text>, Date of Source: </xsl:text>
        <xsl:value-of select="translate($n-dateofexemptedsource,'-','')"/>
      </xsl:when>
    </xsl:choose>
    <xsl:if test="($n-declassdate != '') and (contains($n-declassexception,'25X1-human'))">
      <br/> 
      <b><font color="red"><xsl:text>( WARNING! This document contains both a declassification date and a declassification exemption of 25X1-human. )</xsl:text></font></b>
    </xsl:if>
    <xsl:if test="($n-declassevent != '') and (contains($n-declassexception,'25X1-human'))">
      <br/> 
      <b><font color="red"><xsl:text>( WARNING! This document contains both a declassification event and a declassification exemption of 25X1-human. )</xsl:text></font></b>
    </xsl:if>
    </p>
  </xsl:if>

</xsl:template>

</xsl:stylesheet>

<!-- **************************************************************** -->
<!--                            UNCLASSIFIED                          -->
<!-- **************************************************************** -->