function toggleView(e) {
  var anchor;

  if ((e.nodeType == 1) && (e.tagName == 'A')) {
    anchor = e;
  } else if (e.srcElement && (e.srcElement.tagName == 'A')) {
    anchor = e.srcElement;
  } else if (e.currentTarget && (e.currentTarget.tagName == 'LI')) {
    anchor      = getFirstChildNode(e.currentTarget, 'A');
    anchor.href = '#';
  }

  if (anchor && anchor.parentNode && (anchor.parentNode.childNodes.length > 0)) {
    var ul = getNode(anchor.parentNode.childNodes, 'UL', 'closed');

    if (!ul) return true;

    if (ul.style.display == 'block') {
      ul.style.display = 'none';
      anchor.className = 'closed';
    } else {
      ul.style.display = 'block';
      anchor.className = 'open';
    }

    if (typeof(e.cancelBubble) != undefined) {
      e.cancelBubble = true;
    }

    return false;
  }

  return true;
} // toggleView

function initMenu(e) {
  if (!document.getElementsByTagName) return;

  var as      = document.getElementsByTagName('a');
  var aNodes  = getNodes(as, 'A', 'closed');

  var uls     = document.getElementsByTagName('ul');
  var ulNodes = getNodes(uls, 'UL', 'closed');

  for (var i = 0; i < ulNodes.length; i++) {
    var ul = ulNodes[i];
    ul.style.display = 'none';
  }

  for (var i = 0; i < aNodes.length; i++) {
    var a = aNodes[i];
    var li = a.parentNode;

    if (li && (li.nodeType == 1) && (li.tagName == 'LI')) {
      addEvent(li, 'click', toggleView);
    }
  }
} // initMenu

addEvent(window, 'load', initMenu);