require File.dirname(__FILE__) + '/../test_helper'

class ViewerViewTest < Test::Rails::ViewTestCase

  fixtures :topics, :users, :settings, :support_materials
 
  # testing the view for the index action of TopicsController
  def test_index_with_url
    assigns[:support_material] = support_materials(:google)
    assigns[:content_url]      = support_materials(:google).url
    render :action => 'index', :layout => false
    
    assert_tag :tag => 'frame', :attributes => { :src => "/viewer/header/1" }
    assert_tag :tag => 'frame', :attributes => { :src => support_materials(:google).url }
  end

  def test_index_with_file
    assigns[:support_material] = support_materials(:uploaded_file)
    assigns[:content_url]      = "/viewer/content/#{support_materials(:uploaded_file).id}"
    render :action => 'index', :layout => false
    
    assert_tag :tag => 'frame', :attributes => { :src => "/viewer/header/#{support_materials(:uploaded_file).id}" }
    assert_tag :tag => 'frame', :attributes => { :src => "/viewer/content/#{support_materials(:uploaded_file).id}" }
  end
  
end