require File.dirname(__FILE__) + '/../test_helper'

# We are testing LibraryController's views
class LibraryViewTest < Test::Rails::ViewTestCase

  fixtures :support_materials

  def test_form_partial
    render_form_partial(:google)
    assert_radio_button_is_checked "type_url"
  end

  def test_form_partial_file
    render_form_partial(:pdf)
    assert_radio_button_is_checked "type_file"
  end
    
  # def test_form_shows_existing_filename
  #   render_form_partial(:pdf)    
  #   assert_tag :input, {:attributes => {
  #     :type => 'file', 
  #     :name => 'support_material[uploaded_data]'},
  #     :value => support_materials(:pdf).filename} # FIXME
  #     }
  # end
  
 private
  
  def render_form_partial(support_material_name)
    assigns[:support_material] = support_materials(support_material_name)
    render :partial => 'form'    
  end
  
end