require File.dirname(__FILE__) + '/../test_helper'

# Create a dummy controller for layout views. This lets the setup use the
# right path with minimum fuss.
class LayoutsController < ApplicationController; end

class LayoutsViewTest < Test::Rails::ViewTestCase

  fixtures :topics, :users, :settings, :comments
  
  def setup
    super
    assigns[:current_user] = users(:ernest)
  end

  def test_default
    # Template set-up
    @request.request_uri = '/foo'
    
    # Render an empty string with the 'application' layout.
    render :text => '', :layout => 'application'

  end
  
  def test_settings_data_used_for_help_and_contact
    render :text => '', :layout => 'application'
    
    # depends on :admin_email and :consultation_name
    assert_tag :tag => 'a', :content => 'Contact Us',
      :attributes => { :href => 'mailto:admin@example.com?subject=Sustainable%20Development' }
    assert_tag :tag => 'a', :content => 'Help',       
      :attributes => { :href => 'mailto:admin@example.com?subject=Help%20with%20Sustainable%20Development' }
  end
  
  def test_not_explosive_when_settings_missing
    Settings.destroy_all
    
    render :text => '', :layout => 'application'
  end
end