require File.dirname(__FILE__) + '/../test_helper'

class ParticipantTest < Test::Rails::TestCase
  fixtures :users, :readings, :comments, :ratings

  # Test participants role
  def test_role
    assert_equal :participant, Participant.find(:first).role
  end
  
  def test_should_create_participant
    assert_valid create_participant
  end
  
  # @@@ temporarily disabled anything to do with usernumber
  #
  # user_number required to create new participant
  #def test_should_require_user_number
  #  p = create_participant(:user_number => nil)
  #  assert p.errors.on(:user_number)
  #end
  #
  ## test uniqueness of user_number
  #def test_user_number_uniqueness
  #  p = create_participant(:user_number => users(:grace).user_number)
  #  assert p.errors.on(:user_number)
  #end
  #
  ## handle(name) required to create new participant
  #def test_should_require_user_name
  #  p = create_participant(:name => nil)
  #  assert p.errors.on(:name)
  #end

  # handle(name) required to create new participant
  def test_name_must_uniqueness
    p = create_participant(:name => users(:ernest).name)
    assert p.errors.on(:name)
  end
  
  def test_take_reads_from_guest_account
    assert_nothing_raised { users(:ernest).take_activity_from_guest_account!(users(:visitor1)) }
  end
  
  def test_take_reads_from_guest_account_destroys_guest_account
    assert_difference(User, :count, '', -1) do
      users(:ernest).take_activity_from_guest_account!(users(:visitor1))
    end
    assert_record_not_found(User, users(:visitor1).id)
  end
  
  def test_take_reads_from_guest_account_moves_readings
    assert_difference(users(:ernest).readings, :count, '', 2) do
      users(:ernest).take_activity_from_guest_account!(users(:visitor1))
    end
  end
  
  def test_take_reads_from_guest_account_moves_ratings
    assert_difference(users(:ernest).ratings, :count, '', 1) do
      users(:ernest).take_activity_from_guest_account!(users(:visitor1))
    end
  end
  
  def test_take_reads_from_guest_account_does_not_destroy_non_guest
    assert_no_difference(User, :count) do
      users(:ernest).take_activity_from_guest_account!(users(:laura))
    end
  end

  def test_after_create_should_set_user_login_key
    joe = create_participant
    assert joe.login_key, "login key is missing"
    assert !joe.login_key.blank?, "login key is blank"
  end
  
  def test_province
    assert_equal "Newfoundland and Labrador", users(:quentin).province
    joe = create_participant
    assert_equal 'Ontario', joe.province
  end
  
  def test_province_not_explosive_when_no_postal_code
    joe = create_user_with_postal_code('')
    assert_nil joe.province
  end
  
  def test_province_not_explosive_when_bad_postal_code
    joe = create_user_with_postal_code('Z1A')
    assert_nil joe.province
  end
  
  def test_old_complete_postal_code_not_invalid
    assert_valid create_participant(:postal_code => 'k1r 4k7')
  end
  
  protected
  def create_participant(options = {})
    Participant.create({
      :name => 'Jeremy', 
      :email => 'quire@example.com', 
      :password => 'quire',
      :password_confirmation => 'quire',
      :user_number => '392109',
      :postal_code => 'K1R',
      :gender => 1,
      :year_of_birth => '1970'
      }.merge(options))
  end
  
  # Creates a user with a specific (potentially invalid) postal code.
  # Does not validate when saving.
  def create_user_with_postal_code(postal_code)
    joe = create_participant
    joe.postal_code = postal_code
    joe.save(false)  
    joe  
  end
end
