require File.dirname(__FILE__) + '/../test_helper'

class ExpertTest < Test::Rails::TestCase
  fixtures :users

  # Test experts role
  def test_role
    assert_equal :expert, Expert.find(:first).role
  end
  
  def test_expert_permissions_limited
    xem = Expert.new
    assert_not_permitted_to xem, :metrics_index
    assert_not_permitted_to xem, :system_index
  end
  
  def test_nik_is_special
    nik = Expert.new(:email => 'nnanos@sesresearch.com')
    assert_permitted_to nik, :access_admin_nav
    assert_permitted_to nik, :metrics_index
    assert_permitted_to nik, :fly_to_the_moon  
  end
  
  def assert_permitted_to(user, permission)
    assert user.has_permission_to?(permission), "#{permission} denied for #{user}"
  end
  def assert_not_permitted_to(user, permission)
    assert !user.has_permission_to?(permission), "#{permission} denied for #{user}"
  end
end
