require File.dirname(__FILE__) + '/../test_helper'

class BlogsHelperTest < HelperTestCase

  include BlogHelper
  include CommentHelper
  include ApplicationHelper
  include ActionView::Helpers::TextHelper
  include ActionView::Helpers::DateHelper

  fixtures :users, :snippets, :comments

  def setup
    super
    @blog_font_page_greeting = snippets(:news)
  end
  
  def test_blog_font_page_greeting_admin
    @current_user = users(:laura)
    assert_match snippets(:news).body, blog_font_page_greeting
    assert_match 'Edit this snippet', blog_font_page_greeting
  end
  
  def test_blog_front_page_greeting_non_admin
    [:quentin, :visitor1, :frank].each do |user|
      @current_user = users(user)
      assert_match snippets(:news).body, blog_font_page_greeting
      assert_no_match %r{Edit this snippet}, blog_font_page_greeting
    end
  end

  def test_blog_hot_comment
    output = blog_hot_comment(comments(:first_post))
    assert_match comments(:first_post).body, output
    assert_match comments(:first_post).user.name, output
    assert_match "http://test.host/topics/show/1#comment_1", output
  end
  
end
