require File.dirname(__FILE__) + '/../test_helper'
require 'metrics_controller'

# Re-raise errors caught by the controller.
class MetricsController; def rescue_action(e) raise e end; end

class MetricsControllerTest < Test::Rails::TestCase
  fixtures :comments, :users, :topics, :ratings, :readings 
  
  def setup
    @controller = MetricsController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    @request.session[:user] = users(:laura).id # laura is an admin
  end

  def test_no_comments
    Comment.destroy_all
    assert_nothing_raised { get :index }
  end
  
  def test_no_topics
    Topic.destroy_all
    assert_nothing_raised { get :index }
  end
  
  def test_no_ratings
    AbstractRating.delete_all
    assert_nothing_raised { get :index }
  end
  
  def test_no_reading
    Reading.delete_all
    assert_nothing_raised { get :index }
  end
  
end
