require File.dirname(__FILE__) + '/../test_helper'

class ExpertsControllerTest < Test::Rails::ControllerTestCase

  fixtures :topics, :users, :settings, :support_materials, :readings
  
  def setup
    super
    login_as :laura
  end
  
  def test_show_new
    get 'new'
    assert_response :success
    assert_assigned :expert    
  end
  
  def test_create_expert
    assert_difference(Expert, :count) do
      post_new_expert
    end
  end
  
  def test_create_expert_sets_flash
    post_new_expert
    assert flash[:notice]
  end
  
  def test_create_expert_redirect
    post_new_expert
    assert_response :redirect
  end
  
  def post_new_expert
    post :new, :expert => {:name => 'Edward', :email => 'ed@test.com', :password => 'expert', :password_confirmation => 'expert', :bio => 'Expert he is'}
  end

  # only admin can access the expert controller
  def test_redirect_participant
    login_as :ernest # a participant
    get :index
    assert_response :redirect
  end

  def test_redirect_expert
    login_as :frank # an editor
    get :index
    assert_response :redirect
  end
  
  def test_permit_admin
    login_as :laura # an admin
    get :index
    assert_response :success
  end

  
  def test_index_shows_experts
    get :index
    assert_assigned :experts
  end
  
  def test_update_not_explosive
    assert_nothing_raised { update_user }
  end
  
  def test_edit_should_redirect
    update_user
    assert_response :redirect
  end
  
  def test_edit_should_set_flash
    update_user
    assert !flash.empty?
    assert flash[:notice]
    assert_equal "Expert Account Updated", flash[:notice]
  end
  
  def update_user
    post :edit, {
      "commit"=>"Save this Expert Account", 
      "id"=>"3", 
      "expert"=>{
        "name"=>"Frank", 
        "password_confirmation"=>"silly", 
        "picture"=>"",
        "bio"=>"Sign up now to be instantly ", 
        "password"=>"silly", 
        "picture_temp"=>"", 
        "email"=>"frank@omara.ca"
      }
    }
  end
end
