CREATE TABLE `comments` (
  `id` int(11) NOT NULL auto_increment,
  `body` text,
  `created_by` int(11) default NULL,
  `created_at` datetime default NULL,
  `topic_id` int(11) default '0',
  `root_id` int(11) default '0',
  `parent_id` int(11) default '0',
  `lft` int(11) default '0',
  `rgt` int(11) default '0',
  `depth` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `ratings` (
  `id` int(11) NOT NULL auto_increment,
  `value` int(11) NOT NULL default '0',
  `subject_id` int(11) NOT NULL default '0',
  `participant_id` int(11) default NULL,
  `created_on` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `readings` (
  `id` int(11) NOT NULL auto_increment,
  `participant_id` int(11) NOT NULL default '0',
  `support_material_id` int(11) NOT NULL default '0',
  `created_at` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `schema_info` (
  `version` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL auto_increment,
  `var` varchar(255) NOT NULL default '',
  `value` varchar(255) default NULL,
  `created_at` datetime default NULL,
  `updated_at` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `support_materials` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `url` varchar(255) default '',
  `topic_id` int(11) NOT NULL default '0',
  `file` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `topics` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `introduction` text,
  `body_copy` text,
  `for` date NOT NULL default '0000-00-00',
  `expert_id` int(11) default NULL,
  `approved` blob,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `type` varchar(255) default NULL,
  `email` varchar(100) default NULL,
  `crypted_password` varchar(40) default NULL,
  `salt` varchar(40) default NULL,
  `created_at` datetime default NULL,
  `bio` text,
  `picture` varchar(255) default NULL,
  `user_number` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO schema_info (version) VALUES (16)