class UserObserver < ActiveRecord::Observer
  observe RegisteredUser, Participant, Expert # this shouldn't need to be here, but it solves the problem
  
  def after_create(user)
    user.reset_login_key!  # must be done in the observer to guarantee it's set
                           # before the email is sent
    UserNotifier.deliver_signup_notification(user)
  end

end