# Schema as of Thu Oct 12 19:50:42 EDT 2006 (schema version 28)
#
#  id                  :integer(11)   not null
#  name                :string(255)   
#  type                :string(255)   
#  email               :string(100)   
#  crypted_password    :string(40)    
#  salt                :string(40)    
#  created_at          :datetime      
#  bio                 :text          
#  picture             :string(255)   
#  user_number         :string(255)   
#  year_of_birth       :integer(11)   
#  gender              :integer(11)   default(0)
#  postal_code         :string(255)   
#  login_key           :string(255)   
#

class Guest < User
    
  def record_read_of(what)
    # only record first visit to support material (validation takes care of that)
    logger.info "self is #{self}, ID: #{self.id}"
    readings.create(:readable => what) 
  end    
  
  def handle
    'Guest'
  end
  
  # Remove all guest accounts that have not rated or read anything.
  def Guest.destroy_unused_accounts
    @dormant_ids = []
    Guest.find(:all).each do |g|
      # we don't check for Comments, since Guests cannot comment
      @dormant_ids << g.id if g.ratings.count == 0 && g.readings.count == 0
    end
    Guest.delete(@dormant_ids)
  end
  
end
