# Schema as of Mon Nov 27 15:17:56 EST 2006 (schema version 35)
#
#  id                  :integer(11)   not null
#  value               :integer(11)   default(0), not null
#  subject_id          :integer(11)   default(0), not null
#  participant_id      :integer(11)   
#  created_on          :datetime      not null
#  type                :string(255)   
#

class CommentRating < AbstractRating
  belongs_to :subject, :class_name => 'Comment', :foreign_key => 'subject_id'
  # TODO validates value between 1-5
  validates_uniqueness_of :subject_id, :scope => [:participant_id]
  validate :not_your_own_comment

  def not_your_own_comment
    errors.add('subject', "cannot be your own comment") if comment.user == user
  end
  
  def mapping # Agree (1), Somewhat Agree (2), Unsure (77) Somewhat Disagree (3) Disagree (4)
    # TODO these strings should be stored as application settings
    [ 
      [1,  'Agree'], 
      [2,  'Somewhat Agree'], 
      [77, 'Unsure'],
      [3,  'Somewhat Disagree'],
      [4,  'Disagree']
    ]
  end
  
  # so the language makes more sense
  def comment
    subject
  end
    
end
