class MetricsController < ApplicationController
  before_filter :permision_required
  
  def index
    TopicRating::with_scope(rating_conditions) do
      CommentRating::with_scope(rating_conditions) do
        Comment::with_scope(comment_conditions) do

          # topics
          @topics = Topic.find(:all, :order => 'start_date DESC')
          @topic_most_commented = Topic.reduce_to_most_commented(@topics)
          @topic_most_words     = Topic.reduce_to_most_comment_words(@topics) 
          @topic_most_rated     = Topic.reduce_to_most_rated(@topics)
          @topic_highest_rated  = Topic.reduce_to_best_rated(@topics)          

          # comments
          @comment_most_rated          = Comment.find_most_rated
          @comment_highest_rated       = Comment.find_best_mean_rated
          @comment_most_direct_replies = Comment.find_most_replied
          @comment_most_read           = Comment.find_most_read # are readings scopped? why/why not?

          # calculate all values in this action and scope
          @topic_highest_rated_mean                   = @topic_highest_rated.ratings.average_value_excluding_77s  if @topic_highest_rated
          @topic_highest_rated_ratings_count          = @topic_highest_rated.ratings.count                        if @topic_highest_rated
          @topic_most_commented_comments_length       = @topic_most_commented.comments.length                     if @topic_most_commented
          @topic_most_commented_comments_total_words  = @topic_most_commented.comments.total_words                if @topic_most_commented                                                                           
          @topic_most_words_comments_total_words      = @topic_most_words.comments.total_words                    if @topic_most_words
          @topic_most_words_comments_count            = @topic_most_words.comments.count                          if @topic_most_words

          @comment_most_rated_ratings_count           = @comment_most_rated.ratings.count                         if @comment_most_rated
          @comment_most_rated_ratings_mean            = @comment_most_rated.ratings.average_value_excluding_77s   if @comment_most_rated                                                                                                                                     
          @comment_highest_rated_ratings_mean         = @comment_highest_rated.ratings.average_value_excluding_77s  if @comment_highest_rated
          @comment_highest_rated_ratings_count        = @comment_highest_rated.ratings.count                        if @comment_highest_rated                                                    
          @comment_most_direct_replies_children_count = @comment_most_direct_replies.children_count               if @comment_most_direct_replies                                                                                                                 
          @comment_most_read_readings_count           = @comment_most_read.readings.count                         if @comment_most_read

          @topics_metrics = MetricsGrid.new(@topics) do |m| 
            m.measure(:comment_count){|t| t.comments.count }
            m.measure(:comment_words){|t| t.comments.total_words } 
            m.measure(:rating_count ){|t| t.ratings.count } 
            m.measure(:rating_mean, :min){|t| t.ratings.average(:value, :conditions => 'ratings.value != 77') if t.ratings.length > 0 }
          end
          
        end
      end
    end
  end
  
  private
  
  def action_requires_permission?
    true
  end
  
  def comment_conditions
    if params[:time_scope].to_i > 0
      {:find => { :conditions => ["#{Comment.table_name}.created_at > ?", params[:time_scope].to_i.hours.ago] }}
    else
      {}
    end
  end
  
  def rating_conditions
    if params[:time_scope].to_i > 0
      {:find => { :conditions => ["#{AbstractRating.table_name}.created_on > ?", params[:time_scope].to_i.hours.ago] }}
    else
      {}
    end
  end
end

