require File.dirname(__FILE__) + '/../test_helper'

# Create a dummy controller for layout views. This lets the setup use the
# right path with minimum fuss.
class LayoutsController < ApplicationController; end

class LayoutsViewTest < Test::Rails::ViewTestCase

  fixtures :users
  
  def setup
    super
    @request.request_uri = '/'
  end
  
  def test_title
    assigns[:title] = 'Gorg Castle'
    
    render_layout
    
    assert_title "Canadian Commons - Gorg Castle"
  end
  
  def test_flash_alert
     flash[:alert] = 'The beast of the Blue Rock returns'
     
     render_layout
     
     assert_tag :h3, :attributes => {:class => 'alert'}, :content => 'The beast of the Blue Rock returns'     
  end

  def test_flash_notice
     flash[:notice] = 'The Gospel of Convincing John'
     
     render_layout
     
     assert_tag :h3, :attributes => {:class => 'notice'}, :content => 'The Gospel of Convincing John'     
  end
  
  def test_flash_javascript
    flash[:javascript] = "new Fraggle('Boober');"

    render_layout
    
    assert_tag :script, :content => "new Fraggle('Boober');"
  end
  
  private
  
  def render_layout
    # Render an empty string with the 'application' layout.
    render :text => '', :layout => 'application'
  end
end