require File.dirname(__FILE__) + '/../test_helper'

class RoutesTest < Test::Rails::TestCase
  
  # map.rating_create 'rater/create/:rating_type/:subject_id', :controller => 'rater', :action => 'create'
  def test_rating_create_url
    # assert_recognizes ( expected_options, path, extras={}, [msg] )
    # assert_generates(expected_path, options, defaults={}, extras = {}, message=nil) 
    # assert_routing
    assert_recognizes({:controller => 'rater', :action => 'create', :rating_type => 'cow', :subject_id => "5"}, "rater/create/cow/5")
    assert_generates("rater/create/cow/5", {:controller => 'rater', :action => 'create', :rating_type => 'cow', :subject_id => "5"})
  end
  
  def test_profile_route
    assert_routing('/profile/4', {:controller => 'users', :action => 'show', :id => "4"})
  end
  
  def test_avatar_resource_route
    assert_generates("/avatars/new", {:controller => 'avatars', :action => 'new'})
    assert_routing("/avatars/remove", {:controller => 'avatars', :action => 'remove'})
  end
  
  def test_topic_in_filter_route
    assert_routing("topic/3/registration_filters", 
      {:controller => 'registration_filters', :action => 'index', :topic_id => "3"})
    assert_routing("topic/3/registration_filters/delete/41", 
      {:controller => 'registration_filters', :action => 'delete', :id => "41", :topic_id => "3"})
  end
  
  def test_per_topic_route
    assert_routing('/metrics/show/1', {:controller => 'metrics', :action => 'show', :id => '1'})
  end
  
  def test_viewer_route
    assert_routing('/viewer/index/1', {:action=>"index", :controller=>"viewer", :id=>"1"})
  end
  
  def test_topics_list_route
    assert_routing('/topics/list', {:action=>"list", :controller=>"topics"})
  end
  
  def test_topic_edit_route
    assert_routing('/topics/edit/1', {:action=>"edit", :controller=>"topics", :id=>"1"})
  end
  
  def test_topic_new_route
    assert_routing('/topics/new', {:action=>"new", :controller=>"topics"})
  end
  
  def test_system_route
    assert_routing('/system', {:action=>"index", :controller=>"system"})
  end
end

