require "test/unit"

require File.expand_path(File.dirname(__FILE__) + "/../../lib/postal_code")

class TestPostalCode < Test::Unit::TestCase
  # from http://en.wikipedia.org/wiki/List_of_A_Postal_Codes_of_Canada
  # a list of first-letter codes and their corresponding province
  @@pc_province_matrix = {
    "A" => "NL",
    "B" => "NS",
    "C" => "PE",
    "E" => "NB",
    "G" => "QC",
    "H" => "QC",
    "J" => "QC",
    "K" => "ON",
    "L" => "ON",
    "M" => "ON",
    "N" => "ON",
    "P" => "ON",
    "R" => "MB",
    "S" => "SK",
    "T" => "AB",
    "V" => "BC",
    #"X" => "NU/NT"
    "Y" => "YT"}
    
  def test_newfoundland
    assert_equal "NL", PostalCode::province("A10 1A0")
  end
  
  def test_against_matrix
    @@pc_province_matrix.each do |pc, province|
      assert_equal province, PostalCode::province(pc)
    end
  end

  def test_nunavut
    assert_equal 'NU', PostalCode::province("X0A")
    assert_equal 'NU', PostalCode::province("X0B")
    assert_equal 'NU', PostalCode::province("X0C")
  end

  def test_nwt
    assert_equal 'NT', PostalCode::province("X1A")
    assert_equal 'NT', PostalCode::province("X0D")
  end
  
end