require File.dirname(__FILE__) + '/../test_helper'

class MetricsReportTest < Test::Unit::TestCase
  
  fixtures :topics, :support_materials, :users, :comments, :ratings, :readings
  
  @@report_models = %w{topic support_material participant user comment topic_rating comment_rating support_material_informative_rating support_material_convincing_rating topic_reading comment_reading support_material_reading}
  
  @@report_models.each do |model|
    
    define_method("test_report_not_explosive_#{model}") do
      assert_nothing_raised{ MetricsReport::Export.new(:model => model) }
    end
    
    define_method("test_report_#{model}_returns_a_report") do
      results = MetricsReport::Export.new(:model => model)
      assert_respond_to(results, :as)
      assert_nothing_raised{ results.as(:html) }
      
    end
  end
  
  # now test scoped to topic (but dont report *for* the topic model)
  (@@report_models-['topic']).each do |model|
    define_method("test_report_with_topic_not_explosive_#{model}") do
      assert_nothing_raised { MetricsReport::Export.new(:model => model, :id => 1) }
    end
  end
  
  def test_scoping_topic_to_topic_raises_exception
    assert_raise(ArgumentError) { MetricsReport::Export.new(:model => 'topic', :id => 1) }
  end
  
end
