require File.dirname(__FILE__) + '/../test_helper'

class ExpertTest < Test::Rails::TestCase
  fixtures :users

  # Test experts role
  def test_role
    assert_equal :expert, Expert.find(:first).role
  end
  
  def test_expert_permissions_limited
    xem = Expert.new
    assert_not_permitted_to xem, :metrics_index
    assert_not_permitted_to xem, :system_index
  end
  
  def assert_permitted_to(user, permission)
    assert user.has_permission_to?(permission), "#{permission} denied for #{user}"
  end
  def assert_not_permitted_to(user, permission)
    assert !user.has_permission_to?(permission), "#{permission} denied for #{user}"
  end
end
