require "#{File.dirname(__FILE__)}/../test_helper"

class RememberMeTest < ActionController::IntegrationTest
  fixtures :users, :topics, :comments, :settings
  
  def test_remember_me_cookie_works_for_second_visit
    quentin = users(:quentin)
    v1 = new_visit
    v1.post login_url, {:email => quentin.email, :password => quentin.password, :remember_me => '1'}
    assert !v1.guest_user?
    login_token_cookie = v1.cookies['login_token']
    
    v2 = new_visit
    v2.cookies['login_token'] = login_token_cookie
    v2.get "/"
    assert !v2.guest_user?
    assert_equal quentin.id, v2.session[:user]
  end
  
  
  private
  module CustomAssertions
    def guest_user?
      session[:user] && User.find(session[:user]).is_a?(Guest)
    end
  end
  
  def new_visit
    open_session do |sess|
      sess.extend(CustomAssertions)
    end
  end  
end