module ZipCode
  def ZipCode.state(zip_code)
    # return "MA"
    case zip_code[0...3].to_i
    when 6..7, 9 then 'PR' # and 9..9 
    when 8 then 'VI' #  
    when 10..27 then 'MA' #	
    when 28..29 then 'RI' # 
    when 30..38 then 'NH' # 
    when 39..49 then 'ME' # 
    when 50..59 then 'VT' # 
    when 60..69 then 'CT' # excluding 06390(NY)
    when 70..89 then 'NJ' # 
    when 90..98 then 'AE' # Armed Forces Europe/Canada/Middle East/Africa, with 255 ZIP codes
    when 100..149 then 'NY' # and 06390, 00501, 00544
    when 150..196 then 'PA' # 
    when 197..199 then 'DE' # 
    when 200..200, 202..205, 569 then 'DC' #, 202..205, and 569..569 
    when 201, 220..246 then 'VA' # also some taken from 200..200 DC range
    when 260..219 then 'MD' # 
    when 247..269 then 'WV' # 
    when 270..289 then 'NC' # 
    when 290..299 then 'SC' # 
    when 300..319, 398  then 'GA' # 39901 is in Atlanta
    when 320..349 then 'FL' # 
    when 340..340 then 'AA' # Armed Forces Americas, with 27 ZIP codes
    when 350..369 then 'AL' # 
    when 370..385 then 'TN' # 
    when 386..399 then 'MS' # 
    when 400..427 then 'KY' # 
    when 430..459 then 'OH' # 
    when 460..479 then 'IN' # 
    when 480..499 then 'MI' # 
    when 500..529 then 'IA' # 
    when 530..549 then 'WI' # 
    when 550..567 then 'MN' # 
    when 570..579 then 'SD' # 
    when 580..589 then 'ND' # 
    when 590..599 then 'MT' # 
    when 600..629 then 'IL' # 
    when 630..659 then 'MO' # 
    when 660..679 then 'KS' # 
    when 680..699 then 'NE' # 
    when 700..715 then 'LA' # 
    when 716..729 then 'AR' # 
    when 730..749 then 'OK' # 
    when 750..799, 885 then 'TX' # and ..885  all Houston city zip codes begin 770
    when 800..819 then 'CO' # 
    when 820..831 then 'WY' # and 83414 (otherwise Idaho)
    when 832..839 then 'ID' # 
    when 840..849 then 'UT' # 
    when 850..869 then 'AZ' # 
    when 870..884 then 'NM' # 
    when 889..899 then 'NV' # 
    when 900..961 then 'CA' # 
    when 967..968 then 'HI' # 
    when 970..979 then 'OR' # 
    when 980..994 then 'WA' # 
    when 995..999 then 'AK' #
    end
  end
end

